/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.inquisitor;

import com.ovinter.mythsandlegends.entity.PossessedArmorInquisitorEntity;
import com.ovinter.mythsandlegends.registry.MLParticles;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ImpaleAttackGoal
extends Goal {
    private final PossessedArmorInquisitorEntity mob;
    private LivingEntity target;
    private int attackTicks;
    private final int ATTACK_DURATION = 60;

    public ImpaleAttackGoal(PossessedArmorInquisitorEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.getAnimationId() == 0 && (double)this.mob.getRandom().nextFloat() <= 0.14 && this.mob.hasLineOfSight((Entity)this.target) && this.mob.onGround() && this.mob.impaleCooldown <= 0 && !this.mob.isDeadOrDying();
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.impaleCooldown <= 0;
    }

    public void start() {
        this.mob.setAnimationId(this.mob.IMPALE);
        this.mob.getNavigation().stop();
        this.attackTicks = 0;
    }

    public void tick() {
        ++this.attackTicks;
        if (this.target == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)this.target);
        this.mob.getLookControl().tick();
        if (this.attackTicks == 35) {
            Player player;
            ItemStack stack;
            Vec3 mobPos = this.mob.position();
            Vec3 targetPos = this.target.position();
            double distanceX = targetPos.x - mobPos.x;
            double distanceZ = targetPos.z - mobPos.z;
            float yaw = (float)(Math.atan2(distanceZ, distanceX) * 57.29577951308232) - 90.0f;
            this.mob.setYRot(yaw);
            this.mob.setYBodyRot(yaw);
            this.mob.setYHeadRot(yaw);
            Vec3 direction = targetPos.subtract(mobPos).normalize();
            Vec3 newMobPos = targetPos.subtract(direction.scale(0.8));
            Vec3 dashVector = direction.scale(1.2);
            this.mob.setDeltaMovement(dashVector.x, 0.0, dashVector.z);
            this.mob.hasImpulse = true;
            this.mob.setPos(newMobPos.x, newMobPos.y, newMobPos.z);
            Vec3 pushForward = direction.scale(1.5);
            this.spawnSonicBoomParticles(this.target);
            this.mob.level().playSound(null, this.mob.blockPosition(), (SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.value(), SoundSource.HOSTILE, 2.0f, 1.0f);
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (stack = (player = (Player)livingEntity).getUseItem()).getItem() instanceof ShieldItem) {
                stack.hurtAndBreak(15, (LivingEntity)player, stack.getEquipmentSlot());
                player.getCooldowns().addCooldown(stack.getItem(), 100);
            }
            this.target.hurt(this.mob.damageSources().mobAttack((LivingEntity)this.mob), 12.0f);
            this.target.push(pushForward.x, 0.3, pushForward.z);
        }
        if (this.attackTicks >= 60) {
            this.stop();
        }
    }

    public void stop() {
        this.target = null;
        this.mob.setAnimationId(0);
        this.mob.impaleCooldown = this.mob.IMPALE_COOLDOWN;
        this.attackTicks = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void spawnSonicBoomParticles(LivingEntity target) {
        Level level = this.mob.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 start = this.mob.position().add(0.0, (double)this.mob.getBbHeight() * 0.5, 0.0);
        Vec3 end = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0);
        Vec3 direction = end.subtract(start);
        int steps = 20;
        for (int i = 0; i < steps; ++i) {
            Vec3 pos = start.add(direction.scale((double)i / (double)steps));
            serverLevel.sendParticles((ParticleOptions)MLParticles.AIR_BURST_PARTICLE.get(), pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

