/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.inquisitor;

import com.ovinter.mythsandlegends.entity.PossessedArmorInquisitorEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class SlamAttackGoal
extends Goal {
    private final PossessedArmorInquisitorEntity mob;
    private LivingEntity target;
    private int attackTick;
    private final int ATTACK_DURATION = 45;

    public SlamAttackGoal(PossessedArmorInquisitorEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.onGround() && this.mob.slamCooldown == 0 && this.mob.getAnimationId() == 0 && this.mob.distanceTo((Entity)this.target) <= 5.0f && !this.mob.isDeadOrDying() && !this.mob.isStunned();
    }

    public boolean canContinueToUse() {
        return this.target != null && this.mob.slamCooldown <= 0 && this.target.isAlive();
    }

    public void start() {
        this.mob.setAnimationId(this.mob.SUMMON);
        this.attackTick = 0;
    }

    public void tick() {
        ++this.attackTick;
        if (this.mob.isStunned()) {
            this.stop();
        }
        if (this.target != null) {
            if (this.attackTick == 20) {
                this.performSlamAttack();
            }
            if (this.attackTick >= 45) {
                this.stop();
            }
        }
    }

    public void stop() {
        this.target = null;
        this.mob.setAnimationId(0);
        this.attackTick = 0;
        this.mob.slamCooldown = this.mob.SLAM_COOLDOWN;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    void performSlamAttack() {
        Level level = this.mob.level();
        List entities = level.getEntitiesOfClass(Entity.class, this.mob.getBoundingBox().inflate(6.0), entity -> !(entity instanceof PossessedArmorInquisitorEntity));
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            double deltaX = entity2.getX() - this.mob.getX();
            double deltaZ = entity2.getZ() - this.mob.getZ();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            entity2.hurt(level.damageSources().mobAttack((LivingEntity)this.mob), (float)this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
            if (distance == 0.0) continue;
            ((LivingEntity)entity2).knockback(3.0, -deltaX / distance, -deltaZ / distance);
        }
        level.broadcastEntityEvent((Entity)this.mob, (byte)69);
        level.playSound(null, this.mob.blockPosition(), (SoundEvent)MLSounds.SHOCKWAVE.value(), SoundSource.HOSTILE);
    }
}

