/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.effects;

import com.ovinter.mythsandlegends.registry.MLEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FallingBlockEntity
extends Entity {
    public int duration = 20;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(FallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(FallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);

    public FallingBlockEntity(EntityType<FallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public FallingBlockEntity(Level pLevel, double x, double y, double z, BlockState pBlockState, int duration) {
        this(MLEntities.FALLING_BLOCK.get(), pLevel);
        this.setBlockState(pBlockState);
        this.setPos(x, y + (double)((1.0f - this.getBbHeight()) / 2.0f), z);
        this.setDeltaMovement(Vec3.ZERO);
        this.duration = duration;
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public void setStartPos(BlockPos p_31960_) {
        this.entityData.set(DATA_START_POS, (Object)p_31960_);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.entityData.get(DATA_START_POS);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(DATA_START_POS, (Object)BlockPos.ZERO);
        pBuilder.define(BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState());
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(BLOCK_STATE);
    }

    public void setBlockState(BlockState pBlockState) {
        this.entityData.set(BLOCK_STATE, (Object)pBlockState);
    }

    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround() && this.tickCount > this.duration) {
            this.discard();
        }
        if (this.tickCount > 300) {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        BlockState blockState = this.getBlockState();
        compoundTag.put("block_state", (Tag)NbtUtils.writeBlockState((BlockState)blockState));
        compoundTag.putInt("Time", this.duration);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compoundTag.getCompound("block_state")));
        this.duration = compoundTag.getInt("Time");
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity pEntity) {
        return super.getAddEntityPacket(pEntity);
    }
}

