/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.effects;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HellLightEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    private int lifeTicks;
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(HellLightEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public HellLightEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFESPAN, (Object)50);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLifeTicks(compound.getInt("LifeSpan"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("LifeSpan", this.lifeTicks);
    }

    public void tick() {
        super.tick();
        if (this.getLifeTicks() >= 0) {
            this.setLifeTicks(this.getLifeTicks() - 1);
        }
        if (this.getLifeTicks() <= 0) {
            this.discard();
        }
    }

    public void setLifeTicks(int pTicks) {
        this.entityData.set(LIFESPAN, (Object)pTicks);
        this.lifeTicks = pTicks;
    }

    public int getLifeTicks() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public boolean isOnFire() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", state -> {
            if (this.lifeTicks >= 50) {
                return PlayState.STOP;
            }
            return state.setAndContinue(this.SPAWN);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

