/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.effects;

import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.UUID;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MotlenThornEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    private final RawAnimation DESPAWN = RawAnimation.begin().thenPlay("DESPAWN");
    private int warmupDelayTicks;
    private int lifeTicks;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Boolean> ACTIVATE = SynchedEntityData.defineId(MotlenThornEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(MotlenThornEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(MotlenThornEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public float activateProgress;
    public float prevactivateProgress;

    public MotlenThornEntity(EntityType<? extends MotlenThornEntity> entity, Level level) {
        super(entity, level);
    }

    public MotlenThornEntity(Level worldIn, double x, double y, double z, float yRot, int delay, float damage, LivingEntity casterIn) {
        this(MLEntities.INFERNAL_THORNS.get(), worldIn);
        this.warmupDelayTicks = delay;
        this.setCaster(casterIn);
        this.setDamage(damage);
        this.setYRot(yRot * 57.295776f);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ACTIVATE, (Object)false);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(LIFESPAN, (Object)62);
    }

    public int getLifeTicks() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public void setLifeTicks(int pTicks) {
        this.entityData.set(LIFESPAN, (Object)pTicks);
        this.lifeTicks = pTicks;
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setCaster(@Nullable LivingEntity owner) {
        this.caster = owner;
        this.casterUuid = owner == null ? null : owner.getUUID();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.warmupDelayTicks = compound.getInt("Warmup");
        this.setLifeTicks(compound.getInt("LifeSpan"));
        if (compound.hasUUID("Owner")) {
            this.casterUuid = compound.getUUID("Owner");
        }
        this.setDamage(compound.getFloat("damage"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Warmup", this.warmupDelayTicks);
        compound.putInt("LifeSpan", this.lifeTicks);
        if (this.casterUuid != null) {
            compound.putUUID("Owner", this.casterUuid);
        }
        compound.putFloat("damage", this.getDamage());
    }

    public void tick() {
        this.prevactivateProgress = this.activateProgress;
        if (this.level().isClientSide) {
            if (!this.isActivate() && this.activateProgress < 10.0f) {
                this.activateProgress += 1.0f;
            }
            if (this.getLifeTicks() == 10 || this.getLifeTicks() == 60) {
                this.spawnGroundParticles();
            }
            if (this.getLifeTicks() == 49) {
                this.spawnActivationParticles();
            }
        } else if (this.warmupDelayTicks >= 0) {
            --this.warmupDelayTicks;
            if (this.warmupDelayTicks < 0) {
                this.level().broadcastEntityEvent((Entity)this, (byte)4);
            }
        } else {
            if (this.getLifeTicks() >= 0) {
                this.setLifeTicks(this.getLifeTicks() - 1);
            }
            if (this.getLifeTicks() % 5 == 0) {
                this.applyDamageToEntities();
            }
            if (this.getLifeTicks() < 0) {
                this.discard();
            }
        }
        super.tick();
    }

    public boolean isActivate() {
        return (Boolean)this.entityData.get(ACTIVATE);
    }

    public void setActivate(boolean Activate) {
        this.entityData.set(ACTIVATE, (Object)Activate);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 4) {
            this.triggerAnim("controller", "spawn");
            this.clientSideAttackStarted = true;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)MLSounds.RUPTURE_BURST.value(), this.getSoundSource(), 0.5f, this.random.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }

    private void applyDamageToEntities() {
        for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.3).intersect(this.getBoundingBox()))) {
            if (!livingentity.isAlive() || livingentity.isInvulnerable() || livingentity == this.getCaster()) continue;
            livingentity.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)livingentity), this.getDamage());
        }
    }

    private void spawnGroundParticles() {
        for (int i = 0; i < 80; ++i) {
            BlockState block = this.level().getBlockState(this.blockPosition().below());
            double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            double d1 = this.getY() + 0.03;
            double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), d0, d1, d2, this.random.nextGaussian() * 0.07, this.random.nextGaussian() * 0.07, this.random.nextGaussian() * 0.07);
        }
        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)MLSounds.RUPTURE_BURST.value(), this.getSoundSource(), 0.5f, this.random.nextFloat() * 0.2f + 0.85f, false);
    }

    private void spawnActivationParticles() {
        for (int i = 0; i < 12; ++i) {
            double d0 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            double d1 = this.getY() + 0.05 + this.random.nextDouble();
            double d2 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.CRIMSON_SPORE, d0, d1, d2, (this.random.nextDouble() * 2.0 - 1.0) * 0.3, 0.3 + this.random.nextDouble() * 0.3, (this.random.nextDouble() * 2.0 - 1.0) * 0.3);
        }
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity pEntity) {
        return super.getAddEntityPacket(pEntity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", state -> {
            if (this.getLifeTicks() <= 10) {
                return state.setAndContinue(this.DESPAWN);
            }
            if (this.getLifeTicks() >= 11 && this.getLifeTicks() <= 52) {
                return state.setAndContinue(this.IDLE);
            }
            return PlayState.STOP;
        }).triggerableAnim("spawn", this.SPAWN));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

