/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.event;

import com.mojang.blaze3d.shaders.FogShape;
import com.ovinter.mythsandlegends.client.gui.BossBar;
import com.ovinter.mythsandlegends.client.render.layer.player.ArmorFirstPersonRenderer;
import com.ovinter.mythsandlegends.entity.BlackCharroEntityOld;
import com.ovinter.mythsandlegends.entity.effects.EffectScreenShake;
import com.ovinter.mythsandlegends.registry.MLEffects;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(modid="mythsandlegends", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class EventBusClientEvents {
    private static final ResourceLocation BAR_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/gui/sprites/bar/background.png");

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float ticksExistedDelta = (float)player.tickCount + delta;
        if (!Minecraft.getInstance().isPaused() && player != null) {
            float shakeAmplitude = 0.0f;
            for (EffectScreenShake ScreenShake : player.level().getEntitiesOfClass(EffectScreenShake.class, player.getBoundingBox().inflate(20.0, 20.0, 20.0))) {
                if (!(ScreenShake.distanceTo((Entity)player) < ScreenShake.getRadius())) continue;
                shakeAmplitude += ScreenShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent
    public static void onTick(ClientTickEvent.Pre event) {
        if (!EventBusClientEvents.isGameActive()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ArmorFirstPersonRenderer.clientTick(player);
        if (player.hasEffect(MLEffects.PETRIFIED)) {
            mc.options.keyUp.setDown(false);
            mc.options.keyDown.setDown(false);
            mc.options.keyLeft.setDown(false);
            mc.options.keyRight.setDown(false);
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (EventBusClientEvents.shouldBlockInputs()) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            List nearbyBosses;
            Entity cameraEntity = mc.cameraEntity;
            if (cameraEntity == null) {
                return;
            }
            if (mc.level.dimension().location().getPath().equals("overworld") && !(nearbyBosses = mc.level.getEntities(cameraEntity, cameraEntity.getBoundingBox().inflate(30.0), entity -> {
                BlackCharroEntityOld boss;
                return entity instanceof BlackCharroEntityOld && (boss = (BlackCharroEntityOld)((Object)entity)).isAlive();
            })).isEmpty()) {
                event.setNearPlaneDistance(2.5f);
                event.setFarPlaneDistance(15.0f);
                event.setFogShape(FogShape.SPHERE);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            Entity cameraEntity = mc.cameraEntity;
            if (cameraEntity == null) {
                return;
            }
            boolean inOverworld = mc.level.dimension().location().getPath().equals("overworld");
            List nearbyBosses = mc.level.getEntities(cameraEntity, cameraEntity.getBoundingBox().inflate(30.0), entity -> {
                BlackCharroEntityOld boss;
                return entity instanceof BlackCharroEntityOld && (boss = (BlackCharroEntityOld)((Object)entity)).isAlive();
            });
            if (inOverworld && !nearbyBosses.isEmpty()) {
                event.setRed(0.0f);
                event.setGreen(0.0f);
                event.setBlue(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onBossGuiOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        String bossName = bossEvent.getName().getString();
        BossBar bossBar = BossBar.bossBarMap.get(bossName);
        if (bossBar != null) {
            event.setCanceled(true);
            EventBusClientEvents.prepareBossBar(event, bossBar);
        }
    }

    private static void prepareBossBar(CustomizeGuiOverlayEvent.BossEventProgress event, BossBar BossBar2) {
        event.setIncrement(BossBar2.getIncrement());
        EventBusClientEvents.renderHealthBar(event, BossBar2.getBarHealthOffsetX(), event.getY() + BossBar2.getBarHealthPosY() - 12, BossBar2.getBarHealthWidth(), BossBar2.getBarHealthHeight(), BossBar2.getBarColor());
        EventBusClientEvents.renderBarOverlay(event.getY() + BossBar2.getBarOverlayPosY() - 12, BossBar2.getBarOverlayWidth(), BossBar2.getBarOverlayHeight(), BossBar2.getBarOverlay());
    }

    private static void renderHealthBar(CustomizeGuiOverlayEvent.BossEventProgress event, int OffsetX, int y, int Width, int Height, ResourceLocation barColor) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        int x = (Minecraft.getInstance().getWindow().getGuiScaledWidth() - Width) / 2 + OffsetX;
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        guiGraphics.blit(BAR_BACKGROUND, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
        if (bossEvent.getProgress() > 0.0f) {
            guiGraphics.blit(barColor, x, y, 0.0f, 0.0f, (int)(bossEvent.getProgress() * (float)Width), Height, Width, Height);
        }
    }

    public static void renderBarOverlay(int y, int Width, int Height, ResourceLocation BOSS_TEXTURE) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        int x = (minecraft.getWindow().getGuiScaledWidth() - Width) / 2;
        guiGraphics.blit(BOSS_TEXTURE, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
    }

    public static boolean isGameActive() {
        return Minecraft.getInstance().level != null && Minecraft.getInstance().player != null;
    }

    private static boolean shouldBlockInputs() {
        Minecraft mc = Minecraft.getInstance();
        return mc.player != null && mc.player.hasEffect(MLEffects.PETRIFIED);
    }
}

