/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.armor;

import com.ovinter.mythsandlegends.registry.MLItems;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MLArmorMaterials {
    public static final Holder<ArmorMaterial> IRONSHADE_ARMOR_MATERIAL = MLArmorMaterials.register("ironshade", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 3);
        attribute.put(ArmorItem.Type.LEGGINGS, 6);
        attribute.put(ArmorItem.Type.CHESTPLATE, 7);
        attribute.put(ArmorItem.Type.HELMET, 3);
        attribute.put(ArmorItem.Type.BODY, 11);
    }), 15, 2.0f, 0.1f, MLItems.BOUND_SOUL_INGOT);
    public static final Holder<ArmorMaterial> SOULPIERCER_ARMOR_MATERIAL = MLArmorMaterials.register("soulpiercer", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 2);
        attribute.put(ArmorItem.Type.LEGGINGS, 4);
        attribute.put(ArmorItem.Type.CHESTPLATE, 5);
        attribute.put(ArmorItem.Type.HELMET, 2);
        attribute.put(ArmorItem.Type.BODY, 8);
    }), 15, 2.0f, 0.05f, MLItems.BOUND_SOUL_INGOT);
    public static final Holder<ArmorMaterial> INFERNUM_WARPLATE_ARMOR_MATERIAL = MLArmorMaterials.register("infernum_warplate", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 4);
        attribute.put(ArmorItem.Type.LEGGINGS, 7);
        attribute.put(ArmorItem.Type.CHESTPLATE, 9);
        attribute.put(ArmorItem.Type.HELMET, 4);
        attribute.put(ArmorItem.Type.BODY, 15);
    }), 15, 3.0f, 0.17f, MLItems.INFERNUM_INGOT);

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtection, int enchantability, float toughness, float knockbackResistance, Supplier<Item> ingredientItem) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)name);
        Holder<SoundEvent> equipSound = MLSounds.GENERIC_ARMOR_EQUIPMENT;
        Supplier<Ingredient> ingredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredientItem.get()});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(location));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtection.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)location, (Object)new ArmorMaterial(typeProtection, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }
}

