/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom;

import com.ovinter.mythsandlegends.client.render.item.MoltenFistRenderer;
import com.ovinter.mythsandlegends.entity.effects.MotlenThornEntity;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoltenFistItem
extends SwordItem
implements GeoItem,
GeoAnimatable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation ABILITY = RawAnimation.begin().thenPlay("ABILITY");
    private int TOTAL_FANGS = 8;
    private double BURN_CHANCE = 0.2;

    public MoltenFistItem(Tier tier, Item.Properties properties) {
        super(tier, properties.fireResistant().rarity(Rarity.RARE));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private MoltenFistRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MoltenFistRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.onGround()) {
            Level level2 = player.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)player.getItemInHand(usedHand), (ServerLevel)serverLevel), "attackController", "shoot");
            }
            player.getCooldowns().addCooldown((Item)this, 30);
            for (int i = 0; i < this.TOTAL_FANGS; ++i) {
                this.spawnThorn(i, (LivingEntity)player);
            }
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
        }
        return super.use(level, player, usedHand);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "attackController", "attack");
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.getRandom().nextDouble() < this.BURN_CHANCE) {
            entity.igniteForSeconds(2.0f);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.blazing_fist_tooltip"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.blazing_fist_tooltip2"));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.blazing_fist"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.more_info"));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    private void spawnThorn(int pIndex, LivingEntity pPlayer) {
        int lowestYCheck = Mth.floor((double)pPlayer.getY()) - 1;
        double y = pPlayer.getY() + 1.0;
        float yawRadians = (float)Math.toRadians(90.0f + pPlayer.getYRot());
        double distance = 1.5 + (double)pIndex * 1.25;
        int warmUpDelayTicks = pIndex * 2;
        double x = pPlayer.getX() + (double)Mth.cos((float)yawRadians) * distance;
        double z = pPlayer.getZ() + (double)Mth.sin((float)yawRadians) * distance;
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        boolean foundGround = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape voxelShape;
            BlockPos blockPos1 = blockPos.below();
            BlockState blockState = pPlayer.level().getBlockState(blockPos1);
            if (!blockState.isFaceSturdy((BlockGetter)pPlayer.level(), blockPos1, Direction.UP)) continue;
            if (!pPlayer.level().isEmptyBlock(blockPos) && !(voxelShape = (blockState1 = pPlayer.level().getBlockState(blockPos)).getCollisionShape((BlockGetter)pPlayer.level(), blockPos)).isEmpty()) {
                d0 = voxelShape.max(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((blockPos = blockPos.below()).getY() >= lowestYCheck);
        if (foundGround) {
            MotlenThornEntity thornEntity = new MotlenThornEntity(pPlayer.level(), x, (double)blockPos.getY() + d0, z, yawRadians, warmUpDelayTicks, 4.0f, pPlayer);
            pPlayer.level().addFreshEntity((Entity)thornEntity);
        }
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 3, state -> PlayState.STOP).triggerableAnim("attack", this.ATTACK).triggerableAnim("shoot", this.ABILITY));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

