/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom;

import com.ovinter.mythsandlegends.client.render.item.UmbrasWhisperRenderer;
import com.ovinter.mythsandlegends.entity.projectile.UmbralOrbEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UmbrasWhisperItem
extends SwordItem
implements GeoItem,
GeoAnimatable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    RawAnimation IDLE = RawAnimation.begin().thenPlay("IDLE");

    public UmbrasWhisperItem(Tier pTier, Item.Properties pProperties) {
        super(pTier, pProperties.rarity(Rarity.EPIC));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private UmbrasWhisperRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new UmbrasWhisperRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        pPlayer.getCooldowns().addCooldown((Item)this, 30);
        this.shootUmbralOrb(pLevel, pPlayer);
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.umbras_whisper_tooltip_shift_down"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.umbras_whisper_tooltip_shift_down2"));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.umbras_whisper"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.more_info"));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    private void shootUmbralOrb(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof LivingEntity) {
                Player entity = player;
                UmbralOrbEntity orb = new UmbralOrbEntity(MLEntities.UMBRAL_ORB.get(), level, (LivingEntity)entity);
                orb.setPos(orb.getX(), orb.getEyeY(), orb.getZ());
                orb.shootFromRotation((Entity)player, player.getXRot() + 1.0f, player.getYRot(), 0.0f, 1.0f, 0.0f);
                serverLevel.addFreshEntity((Entity)orb);
                orb.playSound((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_SHOOT.value(), 0.8f, 1.0f);
            }
        }
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

