/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.datagen;

import com.ovinter.mythsandlegends.registry.MLBlocks;
import com.ovinter.mythsandlegends.registry.MLItems;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class MLRecipeProvider
extends RecipeProvider {
    public MLRecipeProvider(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pWriter) {
        this.armorRecipe(pWriter);
        this.toolRecipes(pWriter);
        this.itemRecipes(pWriter);
        this.cookingRecipe(pWriter, "blasting", (ItemLike)MLItems.BOUND_SOUL_INGOT.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MLItems.POSSESSED_ARMOR_FRAGMENT.get()}), 1.0f, 110, "has_fragment", (Item)MLItems.POSSESSED_ARMOR_FRAGMENT.get());
        this.cookingRecipe(pWriter, "blasting", (ItemLike)MLItems.ETHEREAL_FLAME.get(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42779_}), 1.0f, 150, "has_lantern", Items.f_42779_);
        this.smithingUpgradeRecipe(pWriter, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.f_42480_, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_HELMET.get());
        this.smithingUpgradeRecipe(pWriter, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.f_42481_, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_CHESTPLATE.get());
        this.smithingUpgradeRecipe(pWriter, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.f_42482_, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_LEGGINGS.get());
        this.smithingUpgradeRecipe(pWriter, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.f_42483_, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_BOOTS.get());
        this.smithingUpgradeRecipe(pWriter, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), (Item)MLItems.STONY_SHIELD.get(), (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.MALEDICTUM_SHIELD.get());
        this.storageBlockRecipe(pWriter, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_BLOCK.get());
    }

    private void smithingUpgradeRecipe(Consumer<FinishedRecipe> pWriter, Item pTemplate, Item pBase, Item pAddition, Item pResult) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{pTemplate}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{pBase}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{pAddition}), (RecipeCategory)RecipeCategory.COMBAT, (Item)pResult).m_266439_("has_item." + ForgeRegistries.ITEMS.getKey((Object)pAddition).m_135815_(), (CriterionTriggerInstance)MLRecipeProvider.m_125977_((ItemLike)pAddition)).m_266260_(pWriter, "mythsandlegends:" + ForgeRegistries.ITEMS.getKey((Object)pResult).m_135815_());
    }

    private void armorRecipe(Consumer<FinishedRecipe> pRecipeOutput) {
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_HELMET.get(), RecipeCategory.COMBAT, new String[]{"BAB", "B B"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_HELMET.get(), RecipeCategory.COMBAT, new String[]{"BAB", "C C"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), Items.f_41934_), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_CHESTPLATE.get(), RecipeCategory.COMBAT, new String[]{"B B", "BAB", "BBB"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_CHESTPLATE.get(), RecipeCategory.COMBAT, new String[]{"C C", "BAB", "BBB"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), Items.f_41934_), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_LEGGINGS.get(), RecipeCategory.COMBAT, new String[]{"BAB", "B B", "B B"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_LEGGINGS.get(), RecipeCategory.COMBAT, new String[]{"BAB", "B B", "C C"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), Items.f_41934_), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_BOOTS.get(), RecipeCategory.COMBAT, new String[]{"A A", "A A"}, Map.of(Character.valueOf('A'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.BOUND_SOUL_INGOT.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_BOOTS.get(), RecipeCategory.COMBAT, new String[]{"B B", "A A"}, Map.of(Character.valueOf('A'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('B'), Items.f_41934_), List.of((Item)MLItems.BOUND_SOUL_INGOT.get()), 1);
    }

    private void toolRecipes(Consumer<FinishedRecipe> pRecipeOutput) {
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.GARGOYLE_AXE.get(), RecipeCategory.TOOLS, new String[]{"AA ", "AB ", " B "}, Map.of(Character.valueOf('A'), (Item)MLItems.GARGOYLE_SHARD.get(), Character.valueOf('B'), (Item)MLItems.GARGOYLE_FRAGMENT.get()), List.of((Item)MLItems.GARGOYLE_SHARD.get(), (Item)MLItems.GARGOYLE_FRAGMENT.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.STONY_SHIELD.get(), RecipeCategory.COMBAT, new String[]{"ABA", "AAA", " A "}, Map.of(Character.valueOf('A'), (Item)MLItems.GARGOYLE_FRAGMENT.get(), Character.valueOf('B'), (Item)MLItems.GARGOYLE_SHARD.get()), List.of((Item)MLItems.GARGOYLE_SHARD.get(), (Item)MLItems.GARGOYLE_FRAGMENT.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.MOLTEN_FIST.get(), RecipeCategory.COMBAT, new String[]{" BB", "BCS", "SSS"}, Map.of(Character.valueOf('B'), (Item)MLItems.SCORCHED_BONE.get(), Character.valueOf('C'), (Item)MLItems.CORE_OF_ABADDON.get(), Character.valueOf('S'), (Item)MLItems.SCORCHED_SKIN.get()), List.of((Item)MLItems.SCORCHED_BONE.get(), (Item)MLItems.CORE_OF_ABADDON.get(), (Item)MLItems.SCORCHED_SKIN.get()), 1);
    }

    private void itemRecipes(Consumer<FinishedRecipe> pRecipeOutput) {
        this.shapedRecipe(pRecipeOutput, ((Block)MLBlocks.ALTAR_OF_THE_DEAD.get()).m_5456_(), RecipeCategory.MISC, new String[]{"DBB", "ACA", "CCC"}, Map.of(Character.valueOf('D'), Items.f_42678_, Character.valueOf('B'), Items.f_151082_, Character.valueOf('A'), Items.f_41945_, Character.valueOf('C'), Items.f_151024_), List.of(Items.f_42678_), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), RecipeCategory.MISC, new String[]{"ABA", "ACA", "AAA"}, Map.of(Character.valueOf('A'), Items.f_42415_, Character.valueOf('B'), (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Character.valueOf('C'), (Item)MLItems.INFERNUM_INGOT.get()), List.of((Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get()), 2);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULBINDER_AMULET.get(), RecipeCategory.MISC, new String[]{"BAB", "BCB", "BBB"}, Map.of(Character.valueOf('A'), Items.f_42417_, Character.valueOf('B'), Items.f_42587_, Character.valueOf('C'), (Item)MLItems.ETHEREAL_FLAME.get()), List.of(Items.f_42417_, Items.f_42587_, (Item)MLItems.ETHEREAL_FLAME.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.ANTIQUE_EMBLEM.get(), RecipeCategory.MISC, new String[]{" B ", "BCB", " B "}, Map.of(Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), (Item)MLItems.CURSED_CORE.get()), List.of((Item)MLItems.POSSESSED_ARMOR_FRAGMENT.get(), (Item)MLItems.CURSED_CORE.get()), 1);
    }

    private void cookingRecipe(Consumer<FinishedRecipe> consumer, String type, ItemLike result, Ingredient ingredient, float exp, int cookingTime, String unlockKey, Item unlockItem) {
        SimpleCookingRecipeBuilder builder = switch (type.toLowerCase()) {
            case "smelting" -> SimpleCookingRecipeBuilder.m_246179_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)cookingTime);
            case "blasting" -> SimpleCookingRecipeBuilder.m_245681_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)cookingTime);
            default -> throw new IllegalArgumentException("Invalid cooking type: " + type);
        };
        builder.m_126132_(unlockKey, (CriterionTriggerInstance)MLRecipeProvider.m_125977_((ItemLike)unlockItem)).m_126140_(consumer, ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()));
    }

    private void shapedRecipe(Consumer<FinishedRecipe> pConsumer, Item pResult, RecipeCategory pCategory, String[] pPattern, Map<Character, Item> pKeys, List<Item> pUnlockItems, int pCount) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)pCategory, (ItemLike)pResult, (int)pCount);
        for (String line : pPattern) {
            builder.m_126130_(line);
        }
        for (Map.Entry entry : pKeys.entrySet()) {
            builder.m_126127_((Character)entry.getKey(), (ItemLike)entry.getValue());
        }
        for (Item item : pUnlockItems) {
            String unlockKey = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
            builder.m_126132_(unlockKey, (CriterionTriggerInstance)MLRecipeProvider.m_125977_((ItemLike)item));
        }
        builder.m_176498_(pConsumer);
    }

    private void storageBlockRecipe(Consumer<FinishedRecipe> output, Item ingot, Item block) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block).m_126130_("III").m_126130_("III").m_126130_("III").m_126127_(Character.valueOf('I'), (ItemLike)ingot).m_126132_("has_" + BuiltInRegistries.f_257033_.m_7981_((Object)ingot).m_135815_(), (CriterionTriggerInstance)MLRecipeProvider.m_125977_((ItemLike)ingot)).m_176498_(output);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot, (int)9).m_126209_((ItemLike)block).m_126132_("has_" + BuiltInRegistries.f_257033_.m_7981_((Object)block).m_135815_(), (CriterionTriggerInstance)MLRecipeProvider.m_125977_((ItemLike)block)).m_176498_(output);
    }
}

