/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.alp.StealItemAndFleeFromPlayerGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AlpEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RUN_TARGET = RawAnimation.begin().thenLoop("RUN_TARGET");
    private final RawAnimation RUN = RawAnimation.begin().thenLoop("RUN");
    private final RawAnimation DEATH = RawAnimation.begin().thenLoop("DEATH");
    private static final EntityDataAccessor<Boolean> DATA_RUNNING = SynchedEntityData.m_135353_(AlpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_STOLEN = SynchedEntityData.m_135353_(AlpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AlpEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 4;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.ALP_HEALTH).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, DefaultMobAttributes.ALP_MOVEMENT_SPEED).m_22268_(Attributes.f_22277_, DefaultMobAttributes.ALP_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new StealItemAndFleeFromPlayerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            public void m_8056_() {
                AlpEntity.this.setRunning(true);
                super.m_8056_();
            }

            public void m_8041_() {
                AlpEntity.this.setRunning(false);
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RUNNING, (Object)false);
        this.f_19804_.m_135372_(DATA_HAS_STOLEN, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("IsRunning")) {
            this.setRunning(pCompound.m_128471_("IsRunning"));
        }
        this.setHasStolen(pCompound.m_128471_("HasStolen"));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsRunning", this.isRunning());
    }

    public void m_8107_() {
        boolean flag = this.m_21527_();
        if (flag) {
            this.m_20254_(2);
        }
        super.m_8107_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_6667_(DamageSource damageSource) {
        ItemStack stack = this.m_21205_();
        if (!this.m_9236_().f_46443_ && !stack.m_41619_()) {
            this.m_19983_(stack);
        }
        super.m_6667_(damageSource);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Override
    public void setRunning(boolean pIsRunning) {
        this.f_19804_.m_135381_(DATA_RUNNING, (Object)pIsRunning);
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RUNNING);
    }

    public void setHasStolen(boolean pHasStolen) {
        this.f_19804_.m_135381_(DATA_HAS_STOLEN, (Object)pHasStolen);
    }

    public boolean hasStolen() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_STOLEN);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(this.DEATH);
        }
        if (this.isRunning() && this.hasStolen()) {
            return state.setAndContinue(this.RUN);
        }
        if (this.isRunning()) {
            return state.setAndContinue(this.RUN_TARGET);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK) : state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.m_20096_()) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.ALP_STEP.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.ALP_HEALTH.get()).doubleValue());
        this.m_21153_((float)((Double)Config.ALP_HEALTH.get()).doubleValue());
    }
}

