/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LampadEntity
extends MLEntity {
    AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    RawAnimation INTERACTION = RawAnimation.begin().thenPlay("DESTROY");
    RawAnimation FLAME = RawAnimation.begin().thenPlay("FLAME");

    public LampadEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 18;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.LAMPAD_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.LAMPAD_ARMOR).m_22268_(Attributes.f_22281_, DefaultMobAttributes.LAMPAD_DAMAGE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.LAMPAD_MOVEMENT).m_22268_(Attributes.f_22277_, DefaultMobAttributes.LAMPAD_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new AnimatedMeleeAttackGoal(this, 20, 5, 2.7f));
        this.f_21345_.m_25352_(3, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8024_() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_269533_(DamageTypeTags.f_268745_) || pSource.m_276093_(DamageTypes.f_268546_);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_7822_(byte pId) {
        if (pId == 69 && !this.m_21224_()) {
            ParticleGeneratorHelper.generateLampadBoostParticles(this.m_9236_(), (LivingEntity)this);
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_203441_(FluidState pFluidState) {
        return pFluidState.m_205070_(FluidTags.f_13131_) || pFluidState.m_205070_(FluidTags.f_13132_);
    }

    public float m_21692_(BlockPos pPos) {
        if (this.m_9236_().m_8055_(pPos).m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 10.0f;
        }
        return this.m_20077_() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        return state.isMoving() ? state.setAndContinue(this.WALK) : state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.m_6084_()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK);
        }
        return PlayState.CONTINUE;
    }

    PlayState flamePredicate(AnimationState<?> state) {
        return state.setAndContinue(this.FLAME);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "flameController", 0, this::flamePredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::movementPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate).triggerableAnim("interactionAnim", this.INTERACTION)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.LAMPAD_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.LAMPAD_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.LAMPAD_DAMAGE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.LAMPAD_HEALTH.get()).doubleValue());
    }

    private void floatLampad() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }
}

