/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntity;
import com.ovinter.mythsandlegends.entity.projectile.UmbralOrbEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ThrowableProjectile;

public class ShootUmbralOrbGoal
extends Goal {
    BlackCharroEntity mob;
    LivingEntity target;
    private int SHOOT_COOLDOWN = 40;

    public ShootUmbralOrbGoal(BlackCharroEntity pEntity) {
        this.mob = pEntity;
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return this.target != null && this.target.m_6084_() && this.mob.m_20270_((Entity)this.target) >= 4.0f && this.mob.m_142582_((Entity)this.target);
    }

    public boolean m_8045_() {
        return this.SHOOT_COOLDOWN < 0;
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        if (this.SHOOT_COOLDOWN > 0) {
            --this.SHOOT_COOLDOWN;
        } else {
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.mob.m_21391_((Entity)this.target, 30.0f, 30.0f);
            double baseX = this.target.m_20185_() - this.mob.m_20185_();
            double baseY = this.target.m_20186_() - this.mob.m_20186_();
            double baseZ = this.target.m_20189_() - this.mob.m_20189_();
            if (this.mob.getIsRage()) {
                this.shootUmbralOrb(baseX, baseY, baseZ, 0.0);
                this.shootUmbralOrb(baseX, baseY, baseZ, -27.0);
                this.shootUmbralOrb(baseX, baseY, baseZ, 27.0);
            } else {
                this.shootUmbralOrb(baseX, baseY, baseZ, 0.0);
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private void shootUmbralOrb(double x, double y, double z, double angleOffset) {
        this.mob.m_5496_((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_SHOOT.get(), 0.8f, 1.0f);
        UmbralOrbEntity orb = new UmbralOrbEntity((EntityType<? extends ThrowableProjectile>)((EntityType)MLEntities.UMBRAL_ORB.get()), this.mob.m_9236_(), (LivingEntity)this.mob);
        double radians = Math.toRadians(angleOffset);
        double rotatedX = x * Math.cos(radians) - z * Math.sin(radians);
        double rotatedZ = x * Math.sin(radians) + z * Math.cos(radians);
        orb.m_6686_(rotatedX, y, rotatedZ, 1.5f, 0.0f - (float)(this.mob.m_9236_().m_46791_().m_19028_() * 4));
        this.mob.m_9236_().m_7967_((Entity)orb);
        this.mob.triggerAnim("attackController", "shoot");
        this.SHOOT_COOLDOWN = this.mob.m_21023_(MobEffects.f_19620_) ? 20 : 40;
    }
}

