/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.effect.armor;

import com.ovinter.mythsandlegends.effect.armor.ArmorSetEffect;
import com.ovinter.mythsandlegends.effect.armor.InfernumWarplateEffect;
import com.ovinter.mythsandlegends.effect.armor.IronshadeEffect;
import com.ovinter.mythsandlegends.effect.armor.SoulpiercerEffect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mythsandlegends")
public class ArmorSetHandler {
    private static final List<ArmorSetEffect> SET_EFFECTS = List.of(new IronshadeEffect(), new SoulpiercerEffect(), new InfernumWarplateEffect());
    private static final Map<UUID, ArmorSetEffect> ACTIVE_EFFECTS = new HashMap<UUID, ArmorSetEffect>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player genericPlayer = event.player;
        if (genericPlayer.m_9236_().f_46443_) {
            return;
        }
        if (!(genericPlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)genericPlayer;
        boolean isNight = player.m_9236_().m_46462_();
        ArmorSetEffect matched = null;
        for (ArmorSetEffect effect : SET_EFFECTS) {
            if (!effect.matchesFullSet((LivingEntity)player)) continue;
            matched = effect;
            break;
        }
        UUID uuid = player.m_20148_();
        if (matched != null) {
            current = ACTIVE_EFFECTS.get(uuid);
            if (current != matched) {
                if (current != null) {
                    current.removeEffects(player);
                }
                matched.applyEffects(player, isNight);
                ACTIVE_EFFECTS.put(uuid, matched);
            } else {
                matched.applyEffects(player, isNight);
            }
        } else {
            current = ACTIVE_EFFECTS.remove(uuid);
            if (current != null) {
                current.removeEffects(player);
            }
        }
    }
}

