/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.api.util.SendMessageToPlayer;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.CondemnedEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.RageGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.ShootUmbralOrbGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.TeleportGoal;
import com.ovinter.mythsandlegends.entity.effects.HellLightEntity;
import com.ovinter.mythsandlegends.entity.projectile.ShadowHorseEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlackCharroEntity
extends Monster
implements Enemy,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("WALK");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("SHOOT");
    private static final RawAnimation SUMMON_SKELETONS = RawAnimation.begin().thenPlay("SUMMON");
    private static final RawAnimation RAGE = RawAnimation.begin().thenPlay("RAGE");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    public static final RawAnimation TELEPORT = RawAnimation.begin().thenPlay("TELEPORT");
    public static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> DATA_SPAWN_TICKS = SynchedEntityData.m_135353_(BlackCharroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_TELEPORT_CHANCE = SynchedEntityData.m_135353_(BlackCharroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REGENERATION_USES_LEFT = SynchedEntityData.m_135353_(BlackCharroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_RAGE = SynchedEntityData.m_135353_(BlackCharroEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    public float healthPercentage;
    private int lightingCooldown = 60;
    private static int summonCooldown = DefaultMobAttributes.BLACK_CHARRO_SUMMON_COOLDOWN;
    private int combatMessageCooldown = 300;
    private int horseAttackCooldown = 200;

    public BlackCharroEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.BLACK_CHARRO_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.BLACK_CHARRO_ARMOR).m_22268_(Attributes.f_22281_, DefaultMobAttributes.BLACK_CHARRO_DAMAGE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.BLACK_CHARRO_MOVEMENT).m_22268_(Attributes.f_22278_, DefaultMobAttributes.BLACK_CHARRO_KNOCKBACK_RESISTANCE).m_22268_(Attributes.f_22277_, DefaultMobAttributes.BLACK_CHARRO_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RageGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TeleportGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ShootUmbralOrbGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SummonMinionsGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 30.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{CondemnedEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TELEPORT_CHANCE, (Object)9);
        this.f_19804_.m_135372_(DATA_REGENERATION_USES_LEFT, (Object)2);
        this.f_19804_.m_135372_(DATA_SPAWN_TICKS, (Object)40);
        this.f_19804_.m_135372_(DATA_IS_RAGE, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SpawnTimer", this.getSpawnTicks());
        pCompound.m_128405_("Regeneration", this.getRegenerationUsesLeft());
        pCompound.m_128405_("Teleport", this.getTeleportChance());
        pCompound.m_128379_("Invulnerability", this.getIsRage());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setSpawnTicks(pCompound.m_128451_("SpawnTimer"));
        this.setRegenerationUses(pCompound.m_128451_("Regeneration"));
        this.setTeleportChance(pCompound.m_128451_("Teleport"));
        this.setIsRage(pCompound.m_128471_("IsRage"));
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_7822_(byte pId) {
        if (pId == 69) {
            ParticleGeneratorHelper.generateDustParticles((LivingEntity)this, 0.0f, 0.0f, 0.0f, 20.0f, true, true);
        }
        super.m_7822_(pId);
    }

    public void m_8119_() {
        this.handleParticles();
        this.healthPercentage = this.m_21223_() / this.m_21233_();
        this.handleMessageCooldown();
        this.handleSummonLightingCooldown();
        if (summonCooldown > 0) {
            --summonCooldown;
        }
        if (this.getSpawnTicks() <= 0 && !this.m_21224_() && this.m_9236_().f_46443_) {
            ParticleGeneratorHelper.generateSkullParticles((Entity)this);
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.healthPercentage);
        if (this.getSpawnTicks() > 0) {
            this.setSpawnTicks(this.getSpawnTicks() - 1);
        }
        super.m_8024_();
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.getSpawnTicks() > 0 || this.getIsRage()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(pTravelVector);
    }

    public boolean m_20147_() {
        return this.getSpawnTicks() > 0;
    }

    public void m_6457_(ServerPlayer pServerPlayer) {
        super.m_6457_(pServerPlayer);
        this.bossEvent.m_6543_(pServerPlayer);
    }

    public void m_6452_(ServerPlayer pServerPlayer) {
        super.m_6452_(pServerPlayer);
        this.bossEvent.m_6539_(pServerPlayer);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_21224_() || pSource.m_269533_(DamageTypeTags.f_268725_) || pSource.m_269533_(DamageTypeTags.f_268745_) || pSource.m_269533_(DamageTypeTags.f_268581_) || pSource.m_269533_(DamageTypeTags.f_268549_) || pSource.m_276093_(DamageTypes.f_268493_) || pSource.m_269533_(DamageTypeTags.f_268415_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)MLSounds.BLACK_CHARRO_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return !this.m_21224_() ? (SoundEvent)MLSounds.BLACK_CHARRO_AMBIENT.get() : null;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.BLACK_CHARRO_DEATH.get();
    }

    public void playTeleportSound() {
        this.m_216990_((SoundEvent)MLSounds.BLACK_CHARRO_TELEPORT.get());
    }

    public void playRageSound() {
        this.m_5496_((SoundEvent)MLSounds.BLACK_CHARRO_RAGE.get(), 1.5f, 1.0f);
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 50 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.m_9236_().f_46443_) {
            Entity entity = damageSource.m_7639_();
            HellLightEntity hellLightEntity = new HellLightEntity((EntityType)MLEntities.HELL_LIGHT.get(), this.m_9236_());
            Vec3 pos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            hellLightEntity.m_146884_(pos);
            this.m_9236_().m_7967_((Entity)hellLightEntity);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                SendMessageToPlayer.sendRandomMessage("gets_defeated", player, 5);
            }
        }
        super.m_6667_(damageSource);
    }

    public boolean m_7307_(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == ((Object)((Object)this)).getClass()) {
            return true;
        }
        if (entity instanceof CondemnedEntity) {
            return true;
        }
        return super.m_7307_(entity);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void setIsRage(boolean pIsRage) {
        this.f_19804_.m_135381_(DATA_IS_RAGE, (Object)pIsRage);
    }

    public boolean getIsRage() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_RAGE);
    }

    public void setRegenerationUses(int pRegenerationUses) {
        this.f_19804_.m_135381_(DATA_REGENERATION_USES_LEFT, (Object)pRegenerationUses);
    }

    public int getRegenerationUsesLeft() {
        return (Integer)this.f_19804_.m_135370_(DATA_REGENERATION_USES_LEFT);
    }

    public void setTeleportChance(int pTeleportChance) {
        this.f_19804_.m_135381_(DATA_TELEPORT_CHANCE, (Object)pTeleportChance);
    }

    public int getTeleportChance() {
        return (Integer)this.m_20088_().m_135370_(DATA_TELEPORT_CHANCE);
    }

    public void setSpawnTicks(int pSpawnTimer) {
        this.m_20088_().m_135381_(DATA_SPAWN_TICKS, (Object)pSpawnTimer);
    }

    public int getSpawnTicks() {
        return (Integer)this.m_20088_().m_135370_(DATA_SPAWN_TICKS);
    }

    PlayState spawnPredicate(AnimationState<?> state) {
        if (this.getSpawnTicks() > 0) {
            return state.setAndContinue(SPAWN);
        }
        return PlayState.STOP;
    }

    PlayState predicate(AnimationState<?> state) {
        if (this.getSpawnTicks() > 0) {
            return PlayState.STOP;
        }
        return state.isMoving() && this.getSpawnTicks() <= 0 ? state.setAndContinue(WALK) : state.setAndContinue(IDLE);
    }

    protected PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            this.f_20911_ = false;
            return state.setAndContinue(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawnController", 0, this::spawnPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate).triggerableAnim("summon", SUMMON_SKELETONS).triggerableAnim("rage", RAGE).triggerableAnim("teleport", TELEPORT)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "deathController", 0, state -> {
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                state.getController().setAnimation(DEATH);
            }
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate).triggerableAnim("shoot", SHOOT)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void handleMessageCooldown() {
        LivingEntity livingEntity;
        if (this.combatMessageCooldown >= 0) {
            --this.combatMessageCooldown;
        } else if (!this.m_21224_() && (livingEntity = this.m_5448_()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.m_8032_();
            SendMessageToPlayer.sendRandomMessage("combat_message", player, 5);
            this.combatMessageCooldown = 300;
        }
    }

    public void handleSummonLightingCooldown() {
        if ((double)this.healthPercentage <= 0.3 && this.lightingCooldown <= 0 && !this.m_21224_()) {
            this.summonLightingInRadius();
        } else {
            --this.lightingCooldown;
        }
    }

    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.BLACK_CHARRO_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.BLACK_CHARRO_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.BLACK_CHARRO_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)Config.BLACK_CHARRO_MOVEMENT.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.BLACK_CHARRO_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.BLACK_CHARRO_HEALTH.get()).doubleValue());
    }

    public void rage() {
        this.triggerAnim("controller", "rage");
        this.setRegenerationUses((Integer)this.m_20088_().m_135370_(DATA_REGENERATION_USES_LEFT) - 1);
        this.setTeleportChance((Integer)this.m_20088_().m_135370_(DATA_TELEPORT_CHANCE) + 3);
        this.teleportToSky();
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 6, false, false));
        this.playRageSound();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
            serverLevel.m_5594_(null, pos, (SoundEvent)MLSounds.BLACK_CHARRO_RAGE.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
            if (lightningBolt != null) {
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
                lightningBolt.m_20874_(true);
                serverLevel.m_7967_((Entity)lightningBolt);
            }
        }
    }

    public void summonLightingInRadius() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1, false, false));
            for (int i = 0; i < 5; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.0 * 20.0;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.0 * 20.0;
                double x = this.m_20185_() + offsetX;
                double y = this.m_20186_();
                double z = this.m_20189_() + offsetZ;
                BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
                LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
                if (lightningBolt != null) {
                    lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)targetPos));
                    serverLevel.m_7967_((Entity)lightningBolt);
                }
                this.lightingCooldown = 60;
            }
        }
    }

    public void summonShadowHorseCharge(LivingEntity target) {
        Vec3 charroPos = this.m_20182_();
        Vec3 toTarget = target.m_20182_().m_82546_(charroPos).m_82541_();
        Vec3 lateral = new Vec3(-toTarget.f_82481_, 0.0, toTarget.f_82479_).m_82541_();
        int horseCount = 5;
        double spacing = 1.5;
        for (int i = 0; i < horseCount; ++i) {
            int offsetIndex = i - horseCount / 2;
            Vec3 spawnOffset = lateral.m_82490_((double)offsetIndex * spacing);
            Vec3 spawnPos = charroPos.m_82549_(spawnOffset).m_82520_(0.0, 0.5, 0.0);
            ShadowHorseEntity horse = new ShadowHorseEntity((EntityType)MLEntities.SHADOW_HORSE.get(), this.m_9236_());
            horse.m_146884_(spawnPos);
            horse.m_20256_(toTarget.m_82490_(0.6));
            horse.setOwner((LivingEntity)this);
            this.m_9236_().m_7967_((Entity)horse);
        }
        this.m_9236_().m_6263_(null, charroPos.f_82479_, charroPos.f_82480_, charroPos.f_82481_, (SoundEvent)MLSounds.BLACK_CHARRO_TELEPORT.get(), SoundSource.HOSTILE, 1.5f, 1.0f);
    }

    public boolean isValidTeleportLocation(double x, double y, double z) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        return this.m_9236_().m_8055_(pos).m_60795_() && this.m_9236_().m_8055_(pos.m_7495_()).m_280296_();
    }

    public void teleportToSky() {
        BlockPos groundPos = this.m_20183_();
        BlockPos abovePos = groundPos.m_6630_(7);
        if (this.isValidTeleportLocation(this.m_20185_(), this.m_20186_(), this.m_20189_())) {
            this.playTeleportSound();
            this.triggerAnim("controller", "teleport");
            this.m_9236_().m_7605_((Entity)this, (byte)69);
            this.m_6021_((double)abovePos.m_123341_() + 0.5, abovePos.m_123342_(), (double)abovePos.m_123343_() + 0.5);
        }
    }

    void handleParticles() {
        if (this.getSpawnTicks() > 0 || this.m_21224_()) {
            ParticleGeneratorHelper.generateEntitySpawnFromGroundParticles(this.m_9236_(), (LivingEntity)this);
        }
        if (this.m_9236_().f_46443_ && this.getSpawnTicks() == 0 && this.m_6084_()) {
            ParticleGeneratorHelper.generateSkullParticles((Entity)this);
        }
    }

    public class SummonMinionsGoal
    extends Goal {
        BlackCharroEntity mob;
        LivingEntity target;
        private int CONDEMNED_TO_SPAWN = 2;
        private int summonTick;

        public SummonMinionsGoal(BlackCharroEntity pEntity) {
            this.mob = pEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void m_8056_() {
            this.summonTick = 0;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.target.m_6084_() && this.mob.m_20096_() && !this.mob.m_21224_() && summonCooldown <= 0;
        }

        public boolean m_8045_() {
            return summonCooldown <= 0 && this.target != null && this.mob.m_6084_();
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26569_();
            this.target = null;
            this.summonTick = 0;
            summonCooldown = (double)this.mob.healthPercentage <= 0.6 ? 400 : 540;
        }

        public void m_8037_() {
            ++this.summonTick;
            if (this.target != null && summonCooldown == 0) {
                if (this.summonTick >= 25) {
                    this.m_8041_();
                    return;
                }
                if (this.summonTick == 18) {
                    if (this.target instanceof Player) {
                        SendMessageToPlayer.sendRandomMessage("summon_condemned", (Player)this.target, 6);
                    }
                    this.summonCondemned();
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }

        void summonCondemned() {
            this.mob.triggerAnim("controller", "summon");
            this.mob.m_5496_((SoundEvent)MLSounds.BLACK_CHARRO_SUMMON.get(), 10.0f, 1.0f);
            this.CONDEMNED_TO_SPAWN = (double)this.mob.healthPercentage <= 0.6 ? 4 : 2;
            for (int i = 0; i < this.CONDEMNED_TO_SPAWN; ++i) {
                CondemnedEntity condemned = new CondemnedEntity((EntityType<? extends Monster>)((EntityType)MLEntities.CONDEMNED.get()), this.mob.m_9236_());
                double offsetX = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
                double offsetZ = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
                condemned.m_6034_(this.mob.m_20185_() + offsetX, this.mob.m_20186_(), this.mob.m_20189_() + offsetZ);
                this.mob.m_9236_().m_7967_((Entity)condemned);
            }
        }
    }
}

