/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AbstractPossessedArmor;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedRangedAttackGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PossessedArmorArcherEntity
extends AbstractPossessedArmor
implements RangedAttackMob {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RANGED_ATTACK = RawAnimation.begin().thenLoop("RANGED_ATTACK");
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");

    public PossessedArmorArcherEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/possessed_armor_archer.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource() {
        return this.getHasHalfHealth() ? ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_archer_damaged.png") : ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_archer.png");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_ARMOR).m_22268_(Attributes.f_22285_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_ARMOR_TOUGHNESS).m_22268_(Attributes.f_22279_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_MOVEMENT).m_22268_(Attributes.f_22281_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_DAMAGE).m_22268_(Attributes.f_22282_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_ATTACK_KNOCKBACK).m_22268_(Attributes.f_22278_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_KNOCKBACK_RESISTANCE).m_22268_(Attributes.f_22277_, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_FOLLOW_RANGE);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, new AnimatedRangedAttackGoal<PossessedArmorArcherEntity>(this, 1.0, 7, 15.0f));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        this.m_213946_(randomsource, pDifficulty);
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        super.m_213945_(random, difficulty);
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    @Override
    protected PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(this.DEATH);
        }
        if (state.isMoving()) {
            return state.setAndContinue(this.WALK);
        }
        return state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            this.stopTriggeredAnimation("attackController", "ranged");
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.m_20096_()) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.POSSESSED_ARMOR_STEP.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 3, this::attackPredicate).triggerableAnim("ranged", this.RANGED_ATTACK)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARCHER_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARCHER_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARCHER_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARCHER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARCHER_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARCHER_ATTACK_KNOCKBACK.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARCHER_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.POSSESSED_ARMOR_ARCHER_HEALTH.get()).doubleValue());
    }
}

