/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces;

import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.fentanylsolutions.tabfaces.TabFaces;

public class Config {
    public static boolean debugMode = false;
    public static boolean showQuestionMarkIfUnknown = true;
    public static int skinTtl = 120;
    public static int skinTtlInterval = 120;

    public static void synchronizeConfiguration(File configFile) {
        Configuration configuration = new Configuration(configFile);
        Property showQuestionMarkIfUnknownProperty = configuration.get("client", "showQuestionMarkIfUnknown", true, "Should show question mark if player skin unknown? Otherwise shows steve's face.");
        showQuestionMarkIfUnknown = showQuestionMarkIfUnknownProperty.getBoolean();
        skinTtl = configuration.getInt("skinTtl", "client", 120, 15, Integer.MAX_VALUE, "Skin resource refresh time in seconds.");
        skinTtlInterval = configuration.getInt("skinTtlInterval", "client", 120, 15, Integer.MAX_VALUE, "How often should the skin cache invalidator run in seconds.");
        Property debugModeProperty = configuration.get("common", "debugMode", false, "Enable/disable debug logs");
        debugMode = debugModeProperty.getBoolean();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static ConfigCategory getConfigCategoryByString(String category) {
        return new Configuration(TabFaces.confFile).getCategory(category);
    }

    public static class Categories {
        public static final String client = "client";
        public static final String common = "common";
    }

    private static class Defaults {
        public static final boolean showQuestionMarkIfUnknown = true;
        public static final int skinTtl = 120;
        public static final int skinTtlInterval = 120;
        public static final boolean debugMode = false;

        private Defaults() {
        }
    }
}

