/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.fentanylsolutions.tabfaces.TabFaces;
import org.lwjgl.opengl.GL11;

public class GameOverlayGuiHandler
extends GuiIngame {
    FontRenderer fontRenderer;

    public GameOverlayGuiHandler(Minecraft mc) {
        super(mc);
        this.fontRenderer = mc.fontRenderer;
    }

    @SubscribeEvent
    public void open(RenderGameOverlayEvent.Pre e) {
        if (e.type == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            e.setCanceled(true);
        }
        if (e.type != RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            return;
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = Minecraft.getMinecraft().fontRenderer;
        }
        ScoreObjective scoreobjective = this.mc.theWorld.getScoreboard().func_96539_a(0);
        NetHandlerPlayClient handler = this.mc.thePlayer.sendQueue;
        if (this.mc.gameSettings.keyBindPlayerList.getIsKeyPressed() && (!this.mc.isIntegratedServerRunning() || handler.playerInfoList.size() > 1 || scoreobjective != null)) {
            int maxPlayers;
            this.mc.mcProfiler.startSection("playerList");
            List players = handler.playerInfoList;
            ScaledResolution res = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
            int width = res.getScaledWidth();
            int rows = maxPlayers = handler.currentServerMaxPlayers;
            int columns = 1;
            columns = 1;
            while (rows > 20) {
                rows = (maxPlayers + ++columns - 1) / columns;
            }
            int columnWidth = 300 / columns;
            if (columnWidth > 150) {
                columnWidth = 150;
            }
            int left = (width - columns * columnWidth) / 2;
            int border = 10;
            GameOverlayGuiHandler.drawRect((int)(left - 1), (int)(border - 1), (int)(left + columnWidth * columns), (int)(border + 9 * rows), (int)Integer.MIN_VALUE);
            for (int i = 0; i < maxPlayers; ++i) {
                int endX;
                int maxX;
                int xPos = left + i % columns * columnWidth;
                int yPos = border + i / columns * 9;
                GameOverlayGuiHandler.drawRect((int)xPos, (int)yPos, (int)(xPos + columnWidth - 1), (int)(yPos + 8), (int)0x20FFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3008);
                if (i >= players.size()) continue;
                GuiPlayerInfo player = (GuiPlayerInfo)players.get(i);
                ScorePlayerTeam team = this.mc.theWorld.getScoreboard().getPlayersTeam(player.name);
                String displayName = ScorePlayerTeam.formatPlayerName((Team)team, (String)player.name);
                ResourceLocation rl = TabFaces.varInstanceClient.clientRegistry.getTabMenuResourceLocation(player.name);
                if (rl != null) {
                    this.mc.getTextureManager().bindTexture(rl);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Gui.func_152125_a((int)xPos, (int)yPos, (float)8.0f, (float)14.0f, (int)8, (int)18, (int)8, (int)8, (float)64.0f, (float)64.0f);
                }
                this.fontRenderer.drawStringWithShadow(displayName, xPos + 10, yPos, 0xFFFFFF);
                if (scoreobjective != null && (maxX = xPos + columnWidth - 12 - 5) - (endX = xPos + this.fontRenderer.getStringWidth(displayName) + 5) > 5) {
                    Score score = scoreobjective.getScoreboard().func_96529_a(player.name, scoreobjective);
                    String scoreDisplay = EnumChatFormatting.YELLOW + "" + score.getScorePoints();
                    this.fontRenderer.drawStringWithShadow(scoreDisplay, maxX - this.fontRenderer.getStringWidth(scoreDisplay), yPos, 0xFFFFFF);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.getTextureManager().bindTexture(Gui.icons);
                int pingIndex = 4;
                int ping = player.responseTime;
                if (ping < 0) {
                    pingIndex = 5;
                } else if (ping < 150) {
                    pingIndex = 0;
                } else if (ping < 300) {
                    pingIndex = 1;
                } else if (ping < 600) {
                    pingIndex = 2;
                } else if (ping < 1000) {
                    pingIndex = 3;
                }
                this.zLevel += 100.0f;
                this.drawTexturedModalRect(xPos + columnWidth - 12, yPos, 0, 176 + pingIndex * 8, 10, 8);
                this.zLevel -= 100.0f;
            }
        }
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + height), (double)this.zLevel, (double)((float)(u + 0) * f), (double)((float)(v + height) * f1));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)this.zLevel, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + 0), (double)this.zLevel, (double)((float)(u + width) * f), (double)((float)(v + 0) * f1));
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)this.zLevel, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.draw();
    }
}

