/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces.event;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import org.fentanylsolutions.tabfaces.TabFaces;
import org.fentanylsolutions.tabfaces.packet.PacketHandler;
import org.fentanylsolutions.tabfaces.packet.packets.PacketRemoveFromCache;
import org.fentanylsolutions.tabfaces.packet.packets.UsernameUuidPairsPacket;

public class ServerEventHandler {
    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        TabFaces.debug("Player joined server: " + e.player.getDisplayName());
        GameProfile gameProfile = e.player.getGameProfile();
        ArrayList<UsernameUuidPairsPacket.UsernameUuidPair> singlePair = new ArrayList<UsernameUuidPairsPacket.UsernameUuidPair>();
        singlePair.add(new UsernameUuidPairsPacket.UsernameUuidPair(gameProfile.getName(), gameProfile.getId().toString()));
        UsernameUuidPairsPacket.Message msg = new UsernameUuidPairsPacket.Message(singlePair);
        PacketHandler.net.sendToAll((IMessage)msg);
        ArrayList<UsernameUuidPairsPacket.UsernameUuidPair> pairs = new ArrayList<UsernameUuidPairsPacket.UsernameUuidPair>();
        for (EntityPlayerMP player : MinecraftServer.getServer().getConfigurationManager().playerEntityList) {
            pairs.add(new UsernameUuidPairsPacket.UsernameUuidPair(player.getDisplayName(), player.getUniqueID().toString()));
        }
        msg = new UsernameUuidPairsPacket.Message(pairs);
        PacketHandler.net.sendTo((IMessage)msg, (EntityPlayerMP)e.player);
    }

    @SubscribeEvent
    public void onPlayerLEave(PlayerEvent.PlayerLoggedOutEvent e) {
        PacketRemoveFromCache.Message msg = new PacketRemoveFromCache.Message(e.player.getDisplayName());
        PacketHandler.net.sendToAll((IMessage)msg);
    }
}

