/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces.packet.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.fentanylsolutions.tabfaces.TabFaces;

public class PacketRemoveFromCache
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            TabFaces.debug("Received PacketRemoveFromCache for displayName: " + message.displayName);
            TabFaces.varInstanceClient.clientRegistry.removeByDisplayName(message.displayName);
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private String displayName;

        public Message() {
        }

        public Message(String displayName) {
            this.displayName = displayName;
        }

        public void fromBytes(ByteBuf buf) {
            int length = buf.readInt();
            byte[] bytes = new byte[length];
            buf.readBytes(bytes);
            this.displayName = new String(bytes, StandardCharsets.UTF_8);
        }

        public void toBytes(ByteBuf buf) {
            byte[] bytes = this.displayName.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
    }
}

