/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces.packet.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.fentanylsolutions.tabfaces.TabFaces;

public class UsernameUuidPairsPacket
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            TabFaces.debug("Received Username:UUID packet with " + message.pairs.size() + " entries");
            for (UsernameUuidPair pair : message.pairs) {
                TabFaces.debug(" -> " + pair.username + " : " + pair.uuid);
                TabFaces.varInstanceClient.clientRegistry.insert(pair.username, UUID.fromString(pair.uuid), null);
            }
        }
        return null;
    }

    public static class Message
    implements IMessage {
        public List<UsernameUuidPair> pairs = new ArrayList<UsernameUuidPair>();

        public Message() {
        }

        public Message(List<UsernameUuidPair> pairs) {
            this.pairs = pairs;
        }

        public void fromBytes(ByteBuf buf) {
            int pairCount = buf.readInt();
            for (int i = 0; i < pairCount; ++i) {
                String username = this.readString(buf);
                String uuid = this.readString(buf);
                this.pairs.add(new UsernameUuidPair(username, uuid));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pairs.size());
            for (UsernameUuidPair pair : this.pairs) {
                this.writeString(buf, pair.username);
                this.writeString(buf, pair.uuid);
            }
        }

        private String readString(ByteBuf buf) {
            int length = buf.readInt();
            byte[] bytes = new byte[length];
            buf.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        private void writeString(ByteBuf buf, String str) {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
    }

    public static class UsernameUuidPair {
        public final String username;
        public final String uuid;

        public UsernameUuidPair(String username, String uuid) {
            this.username = username;
            this.uuid = uuid;
        }
    }
}

