/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces.registries;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.util.ResourceLocation;
import org.fentanylsolutions.tabfaces.Config;
import org.fentanylsolutions.tabfaces.TabFaces;
import org.fentanylsolutions.tabfaces.compat.LoadedMods;
import org.fentanylsolutions.tabfaces.compat.skinport.SkinPortCompat;
import org.fentanylsolutions.tabfaces.util.ClientUtil;
import org.fentanylsolutions.tabfaces.util.PingUtil;
import org.fentanylsolutions.tabfaces.util.Util;
import org.fentanylsolutions.tabfaces.varinstances.VarInstanceClient;

public class ClientRegistry {
    private Map<String, Data> playerEntities;
    private float tickCounter = 0.0f;
    private final AtomicBoolean fetchingServerStatus = new AtomicBoolean(false);

    public ClientRegistry() {
        this.playerEntities = new ConcurrentHashMap<String, Data>();
    }

    public boolean displayNameInRegistry(String displayName) {
        return this.playerEntities.containsKey(displayName);
    }

    public Data getByDisplayName(String displayName) {
        return this.playerEntities.get(displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String displayName, UUID id, ResourceLocation skinResourceLocation, boolean removeAfterTTL, int ttl) {
        if (id != null) {
            TabFaces.debug("Inserted " + displayName + ", " + id + ", " + (skinResourceLocation != null ? skinResourceLocation.toString() : "null"));
        } else {
            TabFaces.debug("Inserted " + displayName + ", null, " + (skinResourceLocation != null ? skinResourceLocation.toString() : "null"));
        }
        ClientRegistry clientRegistry = this;
        synchronized (clientRegistry) {
            Data existing = this.playerEntities.get(displayName);
            boolean foundSkin = existing != null && existing.foundRealSkin;
            Data newData = new Data(displayName, id, skinResourceLocation, removeAfterTTL, ttl);
            newData.foundRealSkin = foundSkin;
            this.playerEntities.put(displayName, newData);
        }
    }

    public void removeByDisplayName(String displayName) {
        TabFaces.debug("Removed " + displayName + " by displayname");
        this.playerEntities.remove(displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceLocation getTabMenuResourceLocation(String displayName, boolean removeAfterTTL, int ttl) {
        if (VarInstanceClient.minecraftRef.thePlayer != null && VarInstanceClient.minecraftRef.thePlayer.getDisplayName().equals(displayName)) {
            return VarInstanceClient.minecraftRef.thePlayer.getLocationSkin();
        }
        Data data = this.playerEntities.get(displayName);
        if (data == null) {
            if (this.fetchingServerStatus.compareAndSet(false, true)) {
                new Thread(() -> {
                    TabFaces.debug("Starting new ServerPingThread");
                    PingUtil.ServerStatusCallbackClientRegistry callback = new PingUtil.ServerStatusCallbackClientRegistry();
                    PingUtil.pingServer(callback, displayName);
                    this.fetchingServerStatus.set(false);
                    TabFaces.debug("ServerPingThread Done");
                }, "ServerPingThread-" + displayName).start();
            }
            return Config.showQuestionMarkIfUnknown ? TabFaces.varInstanceClient.defaultResourceLocation : AbstractClientPlayer.locationStevePng;
        }
        Data data2 = data;
        synchronized (data2) {
            if (data.skinResourceLocation == null && data.profile == null && !data.resolving) {
                data.resolving = true;
                new Thread(() -> {
                    TabFaces.debug("Starting new GameProfileResolverThread");
                    GameProfile profile = Util.getFullProfile(data.id, data.displayName);
                    TabFaces.debug("Got full profile.");
                    Data data2 = data;
                    synchronized (data2) {
                        data.profile = profile;
                        if (!data.profile.getProperties().isEmpty()) {
                            data.foundRealSkin = true;
                            TabFaces.debug("Properties of " + data.displayName + " are not empty.");
                        }
                        data.resolving = false;
                    }
                }, "GameProfileResolverThread-" + displayName).start();
            } else if (data.skinResourceLocation == null && data.profile != null && !data.resolving) {
                this.insert(displayName, data.id, ClientUtil.skinResourceLocation(data.profile), removeAfterTTL, ttl);
            }
        }
        if (LoadedMods.skinPortLoaded) {
            return SkinPortCompat.getSkinPortCachedSkin(data.id, displayName);
        }
        return data.skinResourceLocation;
    }

    public void clear() {
        TabFaces.debug("Clearing registry");
        this.playerEntities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        this.tickCounter += 1.0f;
        if ((double)this.tickCounter / 20.0 >= (double)Config.skinTtlInterval) {
            this.tickCounter = 0.0f;
            TabFaces.debug("Running skin TTL check (every " + Config.skinTtlInterval + " seconds)");
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<String, Data>> iterator = this.playerEntities.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Data> entry = iterator.next();
                Data data = entry.getValue();
                long elapsedSeconds = (currentTime - data.timestamp) / 1000L;
                if (elapsedSeconds <= (long)data.ttl) continue;
                Data data2 = data;
                synchronized (data2) {
                    if (data.removeAfterTTL) {
                        TabFaces.debug("TTL expired and removeAfterTTL is true, removing entry");
                        iterator.remove();
                    } else if (data.skinResourceLocation != null) {
                        TabFaces.debug("TTL expired, clearing skinResourceLocation");
                        data.skinResourceLocation = null;
                    }
                }
            }
        }
    }

    public class Data {
        String displayName;
        public UUID id;
        public ResourceLocation skinResourceLocation;
        volatile boolean resolving = false;
        volatile GameProfile profile;
        long timestamp;
        boolean removeAfterTTL;
        int ttl;
        public volatile boolean foundRealSkin;

        Data(String displayName, UUID id, ResourceLocation skinResourceLocation, boolean removeAfterTTL, int ttl) {
            this.displayName = displayName;
            this.id = id;
            this.profile = null;
            this.skinResourceLocation = skinResourceLocation;
            this.timestamp = System.currentTimeMillis();
            this.removeAfterTTL = removeAfterTTL;
            this.foundRealSkin = false;
            this.ttl = ttl == -1 ? Config.skinTtl : ttl;
        }
    }
}

