/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import org.fentanylsolutions.tabfaces.Config;
import org.fentanylsolutions.tabfaces.TabFaces;
import org.fentanylsolutions.tabfaces.access.IMixinGui;
import org.fentanylsolutions.tabfaces.access.IMixinGuiScreen;
import org.fentanylsolutions.tabfaces.compat.LoadedMods;
import org.fentanylsolutions.tabfaces.registries.ClientRegistry;
import org.fentanylsolutions.tabfaces.varinstances.VarInstanceClient;
import org.lwjgl.opengl.GL11;

public class ClientUtil {
    public static FontRenderer fontRenderer = null;
    public static int faceWidth = 10;
    public static int serverGuiTTL = 30;
    public static final String fakePlayerUUIDString = "deadbeef-dead-dead-dead-deadbeefdead";
    public static final UUID fakePlayerUUID = UUID.fromString("deadbeef-dead-dead-dead-deadbeefdead");
    public static final Minecraft minecraftInstance = Minecraft.getMinecraft();

    public static ResourceLocation skinResourceLocation(GameProfile profile) {
        Map resultMap = VarInstanceClient.minecraftRef.func_152342_ad().func_152788_a(profile);
        if (resultMap.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            ResourceLocation location = VarInstanceClient.minecraftRef.func_152342_ad().func_152792_a((MinecraftProfileTexture)resultMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            TabFaces.debug(location.toString());
            return location;
        }
        return Config.showQuestionMarkIfUnknown ? TabFaces.varInstanceClient.defaultResourceLocation : AbstractClientPlayer.getLocationSkin((String)profile.getName());
    }

    public static boolean onServer() {
        Minecraft mc = Minecraft.getMinecraft();
        return !mc.isSingleplayer() && !mc.isIntegratedServerRunning() && mc.thePlayer != null;
    }

    public static boolean isOp(EntityPlayerMP entityPlayerMP) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().getConfigurationManager().func_152596_g(entityPlayerMP.getGameProfile());
    }

    public static void drawHoveringTextWithFaces(GuiScreen screen, GameProfile[] profiles, List<String> textLines, int x, int y) {
        if (!textLines.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int boxWidth = 0;
            for (String line : textLines) {
                int tmpWidth = fontRenderer.getStringWidth(line);
                if (tmpWidth <= boxWidth) continue;
                boxWidth = tmpWidth;
            }
            int boxOffsetX = x + 12;
            int boxOffsetY = y - 12;
            int i1 = 8;
            if (textLines.size() > 1) {
                i1 += 2 + (textLines.size() - 1) * 10;
            }
            if (boxOffsetX + boxWidth > screen.width) {
                boxOffsetX -= 28 + boxWidth;
            }
            if (boxOffsetY + i1 + 6 > screen.height) {
                boxOffsetY = screen.height - i1 - 6;
            }
            if (profiles != null) {
                for (String line : textLines) {
                    int tmpWidth;
                    ClientRegistry.Data data = TabFaces.varInstanceClient.clientRegistry.getByDisplayName(line);
                    if (data == null || !data.foundRealSkin || (tmpWidth = fontRenderer.getStringWidth(line) + faceWidth) <= boxWidth) continue;
                    boxWidth = tmpWidth;
                }
            }
            ((IMixinGui)screen).setZLevel(300.0f);
            ((IMixinGuiScreen)screen).getItemRender().zLevel = 300.0f;
            int outerBorderColor = -267386864;
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX - 3, boxOffsetY - 4, boxOffsetX + boxWidth + 3, boxOffsetY - 3, outerBorderColor, outerBorderColor);
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX - 3, boxOffsetY + i1 + 3, boxOffsetX + boxWidth + 3, boxOffsetY + i1 + 4, outerBorderColor, outerBorderColor);
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX - 4, boxOffsetY - 3, boxOffsetX - 3, boxOffsetY + i1 + 3, outerBorderColor, outerBorderColor);
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX + boxWidth + 3, boxOffsetY - 3, boxOffsetX + boxWidth + 4, boxOffsetY + i1 + 3, outerBorderColor, outerBorderColor);
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX - 3, boxOffsetY - 3, boxOffsetX + boxWidth + 3, boxOffsetY + i1 + 3, outerBorderColor, outerBorderColor);
            int innerBorderColor = 0x505000FF;
            int l1 = (innerBorderColor & 0xFEFEFE) >> 1 | innerBorderColor & 0xFF000000;
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX - 3, boxOffsetY - 3 + 1, boxOffsetX - 3 + 1, boxOffsetY + i1 + 3 - 1, innerBorderColor, l1);
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX + boxWidth + 2, boxOffsetY - 3 + 1, boxOffsetX + boxWidth + 3, boxOffsetY + i1 + 3 - 1, innerBorderColor, l1);
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX - 3, boxOffsetY - 3, boxOffsetX + boxWidth + 3, boxOffsetY - 3 + 1, innerBorderColor, innerBorderColor);
            ((IMixinGui)screen).drawGradientRectPub(boxOffsetX - 3, boxOffsetY + i1 + 2, boxOffsetX + boxWidth + 3, boxOffsetY + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < textLines.size(); ++i2) {
                String s1 = textLines.get(i2);
                boolean fake = true;
                if (profiles != null) {
                    for (GameProfile profile : profiles) {
                        if (profile.getId().equals(fakePlayerUUID) || !profile.getName().equals(s1)) continue;
                        if (!TabFaces.varInstanceClient.clientRegistry.displayNameInRegistry(s1)) {
                            TabFaces.varInstanceClient.clientRegistry.insert(s1, profile.getId(), null, true, serverGuiTTL);
                        }
                        ResourceLocation rl = TabFaces.varInstanceClient.clientRegistry.getTabMenuResourceLocation(s1, true, serverGuiTTL);
                        ClientRegistry.Data data = TabFaces.varInstanceClient.clientRegistry.getByDisplayName(profile.getName());
                        if (data == null || !data.foundRealSkin) {
                            rl = null;
                            fontRenderer.drawStringWithShadow(s1, boxOffsetX, boxOffsetY, -1);
                        } else {
                            fontRenderer.drawStringWithShadow(s1, boxOffsetX + faceWidth, boxOffsetY, -1);
                        }
                        if (rl != null) {
                            ClientUtil.drawPlayerFace(rl, (float)boxOffsetX, (float)boxOffsetY, 1.0f);
                        }
                        fake = false;
                        break;
                    }
                }
                if (fake) {
                    fontRenderer.drawStringWithShadow(s1, boxOffsetX, boxOffsetY, -1);
                }
                if (i2 == 0) {
                    boxOffsetY += 2;
                }
                boxOffsetY += 10;
            }
            ((IMixinGui)screen).setZLevel(0.0f);
            ((IMixinGuiScreen)screen).getItemRender().zLevel = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.enableStandardItemLighting();
            GL11.glEnable((int)32826);
        }
    }

    public static void drawPlayerFace(String displayName, int xPos, int yPos, float alpha) {
        ResourceLocation rl = TabFaces.varInstanceClient.clientRegistry.getTabMenuResourceLocation(displayName, false, -1);
        if (rl != null) {
            ClientUtil.drawPlayerFace(rl, (float)xPos, (float)yPos, alpha);
        }
    }

    public static void drawPlayerFace(ResourceLocation rl, float xPos, float yPos, float alpha) {
        if (rl != null) {
            VarInstanceClient.minecraftRef.getTextureManager().bindTexture(rl);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (LoadedMods.skinPortLoaded) {
                ClientUtil.drawTexFloat(xPos, yPos, 8.0f, 8.0f, 8, 8, 8, 8, 64.0f, 64.0f);
                GL11.glEnable((int)3008);
                ClientUtil.drawTexFloat(xPos, yPos, 40.0f, 8.0f, 8, 8, 8, 8, 64.0f, 64.0f);
            } else {
                ClientUtil.drawTexFloat(xPos, yPos, 8.0f, 14.0f, 8, 18, 8, 8, 64.0f, 64.0f);
            }
        }
    }

    public static void drawTexFloat(float x, float y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f4 = 1.0f / tileWidth;
        float f5 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x, (double)(y + (float)height), 0.0, (double)(u * f4), (double)((v + (float)vHeight) * f5));
        tessellator.addVertexWithUV((double)(x + (float)width), (double)(y + (float)height), 0.0, (double)((u + (float)uWidth) * f4), (double)((v + (float)vHeight) * f5));
        tessellator.addVertexWithUV((double)(x + (float)width), (double)y, 0.0, (double)((u + (float)uWidth) * f4), (double)(v * f5));
        tessellator.addVertexWithUV((double)x, (double)y, 0.0, (double)(u * f4), (double)(v * f5));
        tessellator.draw();
    }

    public static void loadTexture(BufferedImage bufferedImage, ResourceLocation resourceLocation) {
        if (bufferedImage == null || resourceLocation == null) {
            TabFaces.error("Error loading texture!");
        } else {
            OfflineTextureObject offlineTextureObject = new OfflineTextureObject(bufferedImage);
            Minecraft.getMinecraft().getTextureManager().loadTexture(resourceLocation, (ITextureObject)offlineTextureObject);
        }
    }

    public static BufferedImage resourceLocationToBufferedImage(ResourceLocation rl) {
        try {
            return ImageIO.read(new File(rl.getResourcePath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage bufferedImageFromBytes(byte[] bytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            return ImageIO.read(is);
        }
        catch (IOException e) {
            TabFaces.error("Failed to read skin bytes into bufferedimage");
            e.printStackTrace();
            return null;
        }
    }

    public static ResourceLocation loadSkinFromBytes(byte[] skinBytes, String displayName) {
        BufferedImage im;
        if (skinBytes == null || skinBytes.length == 0) {
            TabFaces.error("Invalid skinBytes");
            return null;
        }
        if (displayName == null || displayName.length() == 0) {
            TabFaces.error("Invalid displayName");
        }
        if ((im = ClientUtil.bufferedImageFromBytes(skinBytes)) == null) {
            TabFaces.error("Failed to load skin from bytes, im null");
            return null;
        }
        ResourceLocation rl = new ResourceLocation("Tabfaceslol", "tabfaces/" + displayName);
        ClientUtil.loadTexture(im, rl);
        return rl;
    }

    public static class OfflineTextureObject
    extends AbstractTexture {
        private final BufferedImage image;

        public OfflineTextureObject(BufferedImage image) {
            this.image = image;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void loadTexture(IResourceManager arg0) {
            this.deleteGlTexture();
            TextureUtil.uploadTextureImageAllocate((int)this.getGlTextureId(), (BufferedImage)this.image, (boolean)false, (boolean)false);
        }
    }
}

