/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces.util;

import com.mojang.authlib.GameProfile;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.status.INetHandlerStatusClient;
import net.minecraft.network.status.client.C00PacketServerQuery;
import net.minecraft.network.status.client.C01PacketPing;
import net.minecraft.network.status.server.S00PacketServerInfo;
import net.minecraft.network.status.server.S01PacketPong;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.fentanylsolutions.tabfaces.Config;
import org.fentanylsolutions.tabfaces.TabFaces;
import org.fentanylsolutions.tabfaces.registries.ClientRegistry;
import org.fentanylsolutions.tabfaces.util.ClientUtil;

public class PingUtil {
    public static final int DEFAULT_PORT = 25565;

    public static String[] parseAddress(String input) {
        String address;
        int port = 25565;
        if (input.contains(":")) {
            String[] parts = input.split(":", 2);
            address = parts[0];
            try {
                port = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                TabFaces.error("Invalid port number, using default: 25565");
            }
        } else {
            address = input;
        }
        return new String[]{address, String.valueOf(port)};
    }

    public static void pingServer(final ServerStatusCallback callback, final String targetDisplayName) {
        String[] addressPair = PingUtil.parseAddress(ClientUtil.minecraftInstance.func_147104_D().serverIP);
        try {
            final NetworkManager networkManager = NetworkManager.provideLanClient((InetAddress)InetAddress.getByName(addressPair[0]), (int)Integer.parseInt(addressPair[1]));
            networkManager.setNetHandler((INetHandler)new INetHandlerStatusClient(){
                private boolean receivedInfo = false;

                public void handleServerInfo(S00PacketServerInfo packetIn) {
                    this.receivedInfo = true;
                    ServerStatusResponse response = packetIn.func_149294_c();
                    if (callback != null) {
                        ((ServerStatusCallbackClientRegistry)callback).onResponse(response, targetDisplayName);
                    }
                    networkManager.scheduleOutboundPacket((Packet)new C01PacketPing(Minecraft.getSystemTime()), new GenericFutureListener[0]);
                }

                public void handlePong(S01PacketPong packetIn) {
                    networkManager.closeChannel((IChatComponent)new ChatComponentText("Ping complete"));
                }

                public void onDisconnect(IChatComponent reason) {
                    if (!this.receivedInfo && callback != null) {
                        callback.onFailure(new RuntimeException("Failed to ping server: " + reason.getUnformattedText()));
                    }
                }

                public void onConnectionStateTransition(EnumConnectionState oldState, EnumConnectionState newState) {
                }

                public void onNetworkTick() {
                }
            });
            networkManager.scheduleOutboundPacket((Packet)new C00Handshake(5, addressPair[0], Integer.parseInt(addressPair[1]), EnumConnectionState.STATUS), new GenericFutureListener[0]);
            networkManager.scheduleOutboundPacket((Packet)new C00PacketServerQuery(), new GenericFutureListener[0]);
        }
        catch (Throwable t) {
            if (callback != null) {
                callback.onFailure(t);
            }
            TabFaces.error(t.getMessage());
        }
    }

    public static class ServerStatusCallback {
        public void onResponse(ServerStatusResponse response) {
            TabFaces.info(response.toString());
            ServerStatusResponse.PlayerCountData playerData = response.func_151318_b();
            if (playerData != null) {
                int online = playerData.func_151333_b();
                int max = playerData.func_151332_a();
                TabFaces.info("Players: " + online + " / " + max);
                GameProfile[] sample = playerData.func_151331_c();
                if (sample != null && sample.length > 0) {
                    TabFaces.info("Sampled Players:");
                    for (GameProfile profile : sample) {
                        TabFaces.info("- " + profile.getName() + " (" + profile.getId() + ")");
                    }
                } else {
                    TabFaces.info("No player sample provided by server.");
                }
            } else {
                TabFaces.warn("No player data in server response.");
            }
        }

        public void onFailure(Throwable t) {
            TabFaces.error("Failed to ping.");
            t.printStackTrace();
        }
    }

    public static class ServerStatusCallbackClientRegistry
    extends ServerStatusCallback {
        public void onResponse(ServerStatusResponse response, String targetDisplayName) {
            TabFaces.info(response.toString());
            ServerStatusResponse.PlayerCountData playerData = response.func_151318_b();
            if (playerData != null) {
                GameProfile[] profiles = playerData.func_151331_c();
                boolean targetFound = false;
                if (profiles != null && profiles.length > 0) {
                    for (GameProfile profile : profiles) {
                        ClientRegistry.Data res = TabFaces.varInstanceClient.clientRegistry.getByDisplayName(profile.getName());
                        if (res != null && res.id != null) continue;
                        TabFaces.varInstanceClient.clientRegistry.insert(profile.getName(), profile.getId(), null, false, -1);
                        if (!profile.getName().equals(targetDisplayName)) continue;
                        targetFound = true;
                    }
                } else {
                    TabFaces.debug("No players provided by server.");
                }
                if (!targetFound) {
                    TabFaces.varInstanceClient.clientRegistry.insert(targetDisplayName, null, Config.showQuestionMarkIfUnknown ? TabFaces.varInstanceClient.defaultResourceLocation : AbstractClientPlayer.getLocationSkin((String)targetDisplayName), true, Config.skinTtl);
                }
            } else {
                TabFaces.debug("No player data in server response.");
            }
        }
    }
}

