/*
 * Decompiled with CFR 0.152.
 */
package org.fentanylsolutions.tabfaces.util;

import com.mojang.authlib.GameProfile;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.status.INetHandlerStatusClient;
import net.minecraft.network.status.client.C00PacketServerQuery;
import net.minecraft.network.status.client.C01PacketPing;
import net.minecraft.network.status.server.S00PacketServerInfo;
import net.minecraft.network.status.server.S01PacketPong;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.fentanylsolutions.tabfaces.Config;
import org.fentanylsolutions.tabfaces.TabFaces;
import org.fentanylsolutions.tabfaces.registries.ClientRegistry;
import org.fentanylsolutions.tabfaces.util.ClientUtil;

public class PingUtil {
    public static final int DEFAULT_PORT = 25565;

    public static String[] parseAddress(String input) {
        String address;
        int port = 25565;
        if (input.contains(":")) {
            String[] parts = input.split(":", 2);
            address = parts[0];
            try {
                port = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                TabFaces.error("Invalid port number, using default: 25565");
            }
        } else {
            address = input;
        }
        return new String[]{address, String.valueOf(port)};
    }

    public static void pingServer(final ServerStatusCallback callback, final String targetDisplayName) {
        String[] addressPair = PingUtil.parseAddress(ClientUtil.minecraftInstance.func_147104_D().field_78845_b);
        try {
            final NetworkManager networkManager = NetworkManager.func_150726_a((InetAddress)InetAddress.getByName(addressPair[0]), (int)Integer.parseInt(addressPair[1]));
            networkManager.func_150719_a((INetHandler)new INetHandlerStatusClient(){
                private boolean receivedInfo = false;

                public void func_147397_a(S00PacketServerInfo packetIn) {
                    this.receivedInfo = true;
                    ServerStatusResponse response = packetIn.func_149294_c();
                    if (callback != null) {
                        ((ServerStatusCallbackClientRegistry)callback).onResponse(response, targetDisplayName);
                    }
                    networkManager.func_150725_a((Packet)new C01PacketPing(Minecraft.func_71386_F()), new GenericFutureListener[0]);
                }

                public void func_147398_a(S01PacketPong packetIn) {
                    networkManager.func_150718_a((IChatComponent)new ChatComponentText("Ping complete"));
                }

                public void func_147231_a(IChatComponent reason) {
                    if (!this.receivedInfo && callback != null) {
                        callback.onFailure(new RuntimeException("Failed to ping server: " + reason.func_150260_c()));
                    }
                }

                public void func_147232_a(EnumConnectionState oldState, EnumConnectionState newState) {
                }

                public void func_147233_a() {
                }
            });
            networkManager.func_150725_a((Packet)new C00Handshake(5, addressPair[0], Integer.parseInt(addressPair[1]), EnumConnectionState.STATUS), new GenericFutureListener[0]);
            networkManager.func_150725_a((Packet)new C00PacketServerQuery(), new GenericFutureListener[0]);
        }
        catch (Throwable t) {
            if (callback != null) {
                callback.onFailure(t);
            }
            TabFaces.error(t.getMessage());
        }
    }

    public static class ServerStatusCallback {
        public void onResponse(ServerStatusResponse response) {
            TabFaces.info(response.toString());
            ServerStatusResponse.PlayerCountData playerData = response.func_151318_b();
            if (playerData != null) {
                int online = playerData.func_151333_b();
                int max = playerData.func_151332_a();
                TabFaces.info("Players: " + online + " / " + max);
                GameProfile[] sample = playerData.func_151331_c();
                if (sample != null && sample.length > 0) {
                    TabFaces.info("Sampled Players:");
                    for (GameProfile profile : sample) {
                        TabFaces.info("- " + profile.getName() + " (" + profile.getId() + ")");
                    }
                } else {
                    TabFaces.info("No player sample provided by server.");
                }
            } else {
                TabFaces.warn("No player data in server response.");
            }
        }

        public void onFailure(Throwable t) {
            TabFaces.error("Failed to ping.");
            t.printStackTrace();
        }
    }

    public static class ServerStatusCallbackClientRegistry
    extends ServerStatusCallback {
        public void onResponse(ServerStatusResponse response, String targetDisplayName) {
            TabFaces.info(response.toString());
            ServerStatusResponse.PlayerCountData playerData = response.func_151318_b();
            if (playerData != null) {
                GameProfile[] profiles = playerData.func_151331_c();
                boolean targetFound = false;
                if (profiles != null && profiles.length > 0) {
                    for (GameProfile profile : profiles) {
                        ClientRegistry.Data res = TabFaces.varInstanceClient.clientRegistry.getByDisplayName(profile.getName());
                        if (res != null && res.id != null) continue;
                        TabFaces.varInstanceClient.clientRegistry.insert(profile.getName(), profile.getId(), null, false, -1);
                        if (!profile.getName().equals(targetDisplayName)) continue;
                        targetFound = true;
                    }
                } else {
                    TabFaces.debug("No players provided by server.");
                }
                if (!targetFound) {
                    TabFaces.varInstanceClient.clientRegistry.insert(targetDisplayName, null, Config.showQuestionMarkIfUnknown ? TabFaces.varInstanceClient.defaultResourceLocation : AbstractClientPlayer.func_110311_f((String)targetDisplayName), true, Config.skinTtl);
                }
            } else {
                TabFaces.debug("No player data in server response.");
            }
        }
    }
}

