/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.gui.screen.config.ConfigScreenProvider;
import dev.terminalmc.clientsort.client.network.ClientRegistration;
import dev.terminalmc.clientsort.client.util.KeybindManager;
import dev.terminalmc.clientsort.util.Localization;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforgespi.locating.IModFile;

@Mod(value="clientsort", dist={Dist.CLIENT})
@EventBusSubscriber(modid="clientsort", value={Dist.CLIENT})
public class ClientSortNeoForge {
    public ClientSortNeoForge() {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, parent) -> ConfigScreenProvider.getConfigScreen(parent));
        ClientSort.init();
    }

    @SubscribeEvent
    static void registerKeybinds(RegisterKeyMappingsEvent event) {
        KeybindManager.KEYBINDS.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @SubscribeEvent
    static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType().equals((Object)PackType.CLIENT_RESOURCES)) {
            event.addRepositorySource(packConsumer -> {
                String packId = "clientsort-dark-mode";
                IModFile file = ModList.get().getModFileById("clientsort").getFile();
                try {
                    PathPackResources.PathResourcesSupplier supplier = new PathPackResources.PathResourcesSupplier(file.findResource(new String[]{"resourcepacks/" + packId}));
                    PackLocationInfo info = new PackLocationInfo("clientsort:" + packId, (Component)Localization.localized("resourcepack", "dark-mode", new Object[0]), PackSource.BUILT_IN, Optional.empty());
                    Pack pack = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)supplier, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
                    if (pack != null) {
                        packConsumer.accept(pack);
                    }
                }
                catch (NullPointerException e) {
                    e.fillInStackTrace();
                }
            });
        }
    }

    @SubscribeEvent
    static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").optional();
        ClientRegistration.PAYLOADS_S2C.forEach(rp -> ClientSortNeoForge.registerS2C(registrar, rp));
    }

    private static <T extends CustomPacketPayload> void registerS2C(PayloadRegistrar registrar, ClientRegistration.RegisterablePayloadS2C<T> rp) {
        registrar.playToClient(rp.type, rp.streamCodec, (payload, context) -> rp.handler.accept(payload, Minecraft.getInstance(), (LocalPlayer)context.player()));
    }

    @EventBusSubscriber(modid="clientsort", value={Dist.CLIENT})
    static class ClientEventHandler {
        ClientEventHandler() {
        }

        @SubscribeEvent
        public static void afterClientTick(ClientTickEvent.Post event) {
            ClientSort.afterClientTick(Minecraft.getInstance());
        }
    }
}

