/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.CollectPayload;
import dev.terminalmc.clientsort.network.payload.CollectResultPayload;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class CollectHandler
extends PayloadHandler {
    private CollectHandler() {
    }

    public static void handle(CollectPayload payload, MinecraftServer server, class_3222 player) {
        server.execute(() -> CollectHandler.processPayload(server, player, payload.containerId(), menu -> CollectHandler.checkPolicy(player, menu, payload.slotIds()), menu -> SchemaValidator.validateSlotArray(player, menu, payload.slotIds()), menu -> CollectHandler.collect(server, menu, payload.slotIds()), CollectPayload.ID, CollectResultPayload.ID, (result, message) -> new CollectResultPayload(result.code, (String)message, payload.id())));
    }

    private static void collect(MinecraftServer server, class_1703 menu, int[] slotIds) throws PayloadHandlerException {
        block0: for (int i = slotIds.length - 1; i >= 0; --i) {
            int srcSlotId = slotIds[i];
            class_1735 srcSlot = (class_1735)menu.field_7761.get(srcSlotId);
            class_1799 srcStack = srcSlot.method_7677();
            class_1799 srcStackCopy = srcStack.method_7972();
            if (srcStack.method_7960() || srcStack.method_7947() >= srcStack.method_7909().method_7882()) continue;
            for (int j = 0; j < i; ++j) {
                int dstSlotId = slotIds[j];
                class_1735 dstSlot = (class_1735)menu.field_7761.get(dstSlotId);
                class_1799 dstStack = dstSlot.method_7677();
                class_1799 dstStackCopy = dstStack.method_7972();
                if (dstStack.method_7960() || dstStack.method_7947() >= dstStack.method_7909().method_7882() || !class_1799.method_31577((class_1799)srcStack, (class_1799)dstStack)) continue;
                dstSlot.method_32756(srcStack);
                class_1799 expected = srcStackCopy.method_46651(Math.min(srcStackCopy.method_7947() + dstStackCopy.method_7947(), dstSlot.method_7676(srcStackCopy)));
                CollectHandler.validate(server, expected, dstSlot.method_7677(), () -> String.format("Collect operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s'", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy), msg -> CollectHandler.setPolicy(menu, slotIds, msg));
                if (srcStack.method_7960()) continue block0;
            }
        }
    }

    private static void checkPolicy(class_3222 player, class_1703 menu, int[] slotIds) throws PayloadHandlerException.UnsupportedOpException {
        class_1263 container = slotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)slotIds[0])).field_7871 : null;
        Object object = ClientSort.getObj(container, menu);
        if (object == null) {
            throw new PayloadHandlerException.UnsupportedOpException("Reference object is null for inputs '%s', '%s'!".formatted(container == null ? "null" : container.getClass().getName(), menu == null ? "null" : menu.getClass().getName()));
        }
        if (container != player.method_31548()) {
            PolicyManager.checkPolicy(object.getClass(), bl -> bl.sortEnabled);
        }
    }

    private static void setPolicy(class_1703 menu, int[] slotIds, String message) {
        class_1263 container = slotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)slotIds[0])).field_7871 : null;
        Object object = ClientSort.getObj(container, menu);
        if (object == null) {
            ClientSort.LOG.warn("Could not set policy: reference object is null for inputs '{}', '{}'!", container == null ? "null" : container.getClass().getName(), menu == null ? "null" : menu.getClass().getName());
            return;
        }
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), false, true, true), CollectPayload.ID.toString(), message);
    }
}

