/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.mixin.client;

import com.google.common.base.Suppliers;
import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.gui.screen.edit.EditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.util.KeybindManager;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen {
    @Shadow
    @Final
    protected AbstractContainerMenu menu;
    @Shadow
    protected Slot hoveredSlot;
    @Shadow
    private ItemStack draggingItem;
    @Unique
    private final Supplier<ContainerScreenHelper<AbstractContainerScreen<AbstractContainerMenu>>> clientsort$screenHelper = Suppliers.memoize(() -> ContainerScreenHelper.of((AbstractContainerScreen)this, (slot, mouseButton, clickType, playSound) -> new InteractionManager.CallbackEvent(() -> {
        this.slotClicked(slot, ((ISlot)slot).clientsort$getIndexInMenu(), mouseButton, clickType);
        if (playSound) {
            SoundManager.play();
        }
        return InteractionManager.TICK_WAITER;
    })));

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Shadow
    protected abstract void slotClicked(Slot var1, int var2, int var3, ClickType var4);

    @Shadow
    public abstract T getMenu();

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeSlotClicked(Slot slot, int slotId, int mouseButton, ClickType type, CallbackInfo ci) {
        if (slotId < 0 && dev.terminalmc.clientsort.client.ClientSort.operatingClient) {
            ci.cancel();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Supplier<Boolean> op = this.clientsort$getOperation(keyMapping -> keyMapping.matchesMouse(button));
        if (op != null && op.get().booleanValue()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        Supplier<Boolean> op = this.clientsort$getOperation(keyMapping -> keyMapping.matches(keyCode, scanCode));
        if (op != null && op.get().booleanValue()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Unique
    @Nullable
    private Supplier<Boolean> clientsort$getOperation(Function<KeyMapping, Boolean> inputMatcher) {
        boolean isEditKey = inputMatcher.apply(KeybindManager.EDIT_KEY);
        if (!isEditKey && this.hoveredSlot == null) {
            return null;
        }
        Options options = this.minecraft.options;
        if (inputMatcher.apply(options.keyPickItem).booleanValue() && this.minecraft.gameMode.hasInfiniteItems() && (this.hoveredSlot.hasItem() || !this.draggingItem.isEmpty() || !this.menu.getCarried().isEmpty())) {
            return null;
        }
        if (inputMatcher.apply(options.keyDrop).booleanValue() && this.hoveredSlot.hasItem()) {
            return null;
        }
        if (inputMatcher.apply(options.keySwapOffhand).booleanValue()) {
            return null;
        }
        for (int i = 0; i < 9; ++i) {
            if (!inputMatcher.apply(options.keyHotbarSlots[i]).booleanValue()) continue;
            return null;
        }
        if (isEditKey) {
            return this::clientsort$openEditor;
        }
        if (inputMatcher.apply(KeybindManager.SORT_KEY).booleanValue()) {
            return this::clientsort$sort;
        }
        if (inputMatcher.apply(KeybindManager.STACK_FILL_KEY).booleanValue()) {
            return this::clientsort$fillStacks;
        }
        if (inputMatcher.apply(KeybindManager.MATCH_TRANSFER_KEY).booleanValue()) {
            return this::clientsort$matchTransfer;
        }
        if (inputMatcher.apply(KeybindManager.TRANSFER_KEY).booleanValue()) {
            return this::clientsort$transfer;
        }
        return null;
    }

    @Unique
    private boolean clientsort$openEditor() {
        Minecraft.getInstance().setScreen((Screen)new SelectorScreen((AbstractContainerScreen)this));
        return true;
    }

    @Unique
    private boolean clientsort$sort() {
        if (this.hoveredSlot == null) {
            return false;
        }
        SortOrder sortOrder = AbstractContainerScreenMixin.hasShiftDown() ? Config.options().shiftSortOrder : (AbstractContainerScreenMixin.hasControlDown() ? Config.options().ctrlSortOrder : (AbstractContainerScreenMixin.hasAltDown() ? Config.options().altSortOrder : Config.options().sortOrder));
        if (sortOrder != null && sortOrder != SortOrder.NONE) {
            SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((AbstractContainerScreen)this, this.clientsort$screenHelper.get(), this.hoveredSlot, Operation.SORT, false);
            if (operator != null) {
                operator.trySort(sortOrder);
            }
            return true;
        }
        return false;
    }

    @Unique
    private boolean clientsort$fillStacks() {
        SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((AbstractContainerScreen)this, this.clientsort$screenHelper.get(), this.hoveredSlot, Operation.STACK_FILL, false);
        if (operator != null) {
            operator.tryFillStacks();
        }
        return true;
    }

    @Unique
    private boolean clientsort$matchTransfer() {
        SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((AbstractContainerScreen)this, this.clientsort$screenHelper.get(), this.hoveredSlot, Operation.MATCH_TRANSFER, false);
        if (operator != null) {
            operator.tryMatchTransfer();
        }
        return true;
    }

    @Unique
    private boolean clientsort$transfer() {
        SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((AbstractContainerScreen)this, this.clientsort$screenHelper.get(), this.hoveredSlot, Operation.TRANSFER, false);
        if (operator != null) {
            operator.tryTransfer();
        }
        return true;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void afterRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!((Object)((Object)this)).equals(Minecraft.getInstance().screen)) {
            return;
        }
        if (dev.terminalmc.clientsort.client.ClientSort.overlayMessage != null) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 1000.0f);
            dev.terminalmc.clientsort.client.ClientSort.overlayMessage.renderWidget(graphics, mouseX, mouseY, partialTick);
            graphics.pose().popPose();
        }
        if (!ClientSort.debug()) {
            return;
        }
        ContainerScreenHelper<AbstractContainerScreen> helper = ContainerScreenHelper.of((AbstractContainerScreen)this, (a, b, c, d) -> null);
        float scale = 0.7f;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 1000.0f);
        graphics.pose().scale(scale, scale, 0.0f);
        for (Slot slot : this.menu.slots) {
            int slotId = ((ISlot)slot).clientsort$getIndexInMenu();
            if (!(Minecraft.getInstance().screen instanceof EditorScreen)) {
                Object object = dev.terminalmc.clientsort.client.ClientSort.getObj(slot, this.getMenu());
                if (object == null) continue;
                @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
                if (policy != null && policy.ignoredSlots().contains(slotId)) {
                    graphics.drawString(Minecraft.getInstance().font, "\u274c", (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.x) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.y) / scale), 0xFF0000);
                }
            }
            if (AbstractContainerScreenMixin.hasShiftDown()) {
                slotId = ((ISlot)slot).clientsort$getIndexInContainer();
            } else if (AbstractContainerScreenMixin.hasControlDown()) {
                slotId = slot.getContainerSlot();
            }
            graphics.drawString(Minecraft.getInstance().font, String.valueOf(slotId), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.x) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.y + 12) / scale), 0xFFFFFF);
            graphics.drawString(Minecraft.getInstance().font, String.valueOf(helper.getScope(slot).ordinal()), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.x + 12) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.y + 12) / scale), 0xFFFFFF);
        }
        graphics.pose().popPose();
    }
}

