/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui.screen.edit;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Policy;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.mixin.client.accessor.GuiGraphicsAccessor;
import dev.terminalmc.clientsort.mixin.client.accessor.GuiRenderStateAccessor;
import dev.terminalmc.clientsort.util.Localization;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorScreen
extends class_437 {
    private final class_437 lastScreen;
    private final class_465<?> underlay;
    private final LinkedList<TriggerButton> buttons = new LinkedList();
    public final Set<Integer> ignoredSlots = new TreeSet<Integer>();
    private TriggerButton rep;
    private String lowestPolicyKey;
    private boolean dragging;

    public EditorScreen(class_465<?> underlay, TriggerButton button) {
        this(underlay, button, (class_437)underlay);
    }

    public EditorScreen(class_465<?> underlay, TriggerButton button, class_437 lastScreen) {
        super((class_2561)Localization.localized("title", "positionEditor", new Object[0]));
        this.field_22793 = class_310.method_1551().field_1772;
        this.lastScreen = lastScreen;
        this.underlay = underlay;
        this.rep = button;
        this.buttons.add(button);
    }

    public void method_25426() {
        super.method_25426();
        this.underlay.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        if (!this.reloadButtonsAndIgnoredSlots()) {
            this.method_37067();
            return;
        }
        this.rebuildGui();
    }

    private boolean reloadButtonsAndIgnoredSlots() {
        this.buttons.clear();
        this.ignoredSlots.clear();
        this.buttons.addAll(this.getButtons());
        if (this.buttons.size() != 4) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.error("Failed to reload buttons on PositionEditScreen: Button list is too small (expected: {}, actual: {})", 4, this.buttons.size());
            }
            return false;
        }
        this.rep = this.buttons.getFirst();
        ClassPolicy policy = Config.options().classPolicies.get(this.rep.activePolicyKey);
        if (policy != null) {
            this.buttons.forEach(button -> {
                button.field_22763 = button.getPolicyStatus(policy);
            });
            this.ignoredSlots.addAll(policy.ignoredSlots());
        }
        class_1703 keyObject = this.rep.container instanceof class_1277 ? this.underlay.method_17577() : this.rep.container;
        this.lowestPolicyKey = keyObject.getClass().getName();
        return true;
    }

    protected abstract LinkedList<TriggerButton> getButtons();

    private void rebuildGui() {
        this.method_37067();
        int numButtons = 11;
        int x = 2;
        int movingY = this.field_22790 - 21 * numButtons;
        int width = 100;
        int height = 20;
        class_4185 instructionsButton = class_4185.method_46430((class_2561)Localization.localized("editor", "instructions", new Object[0]), button -> {}).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "instructions.tooltip.1", new Object[0]).method_27693("\n\n").method_10852((class_2561)Localization.localized("editor", "instructions.tooltip.2", new Object[0])).method_27693("\n\n").method_10852((class_2561)Localization.localized("editor", "instructions.tooltip.3", new Object[0])).method_27693("\n\n").method_10852((class_2561)Localization.localized("editor", "instructions.tooltip.4", new Object[0])).method_27693("\n\n").method_10852((class_2561)Localization.localized("editor", "instructions.tooltip.5", new Object[0])))).method_46433(x, movingY).method_46437(width, height).method_46431();
        instructionsButton.field_22763 = false;
        this.method_37063((class_364)instructionsButton);
        class_4185 disableButtonsButton = class_4185.method_46430((class_2561)Localization.localized("editor", "disableButtons", new Object[0]).method_27692(class_124.field_1061), button -> class_310.method_1551().method_1507((class_437)new class_410(confirm -> {
            if (confirm) {
                Config.options().showButtons = false;
                Config.save();
                this.method_25419();
            } else {
                class_310.method_1551().method_1507((class_437)this);
            }
        }, (class_2561)Localization.localized("title", "confirm.disableButtons", new Object[0]), (class_2561)Localization.localized("message", "confirm.disableButtons.1", Localization.localized("key", "edit", new Object[0]).method_27692(class_124.field_1065), Localization.localized("option", "buttons", new Object[0]).method_27692(class_124.field_1065)).method_27693("\n\n").method_10852((class_2561)Localization.localized("message", "confirm.disableButtons.2", new Object[0]))))).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "disableButtons.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)disableButtonsButton);
        class_4185 toggleVisibilityButton = class_4185.method_46430((class_2561)Localization.localized("editor", "toggleVisibility", new Object[0]), button -> {
            boolean status = this.buttons.stream().noneMatch(b -> b.field_22763);
            this.buttons.forEach(b -> {
                b.field_22763 = status;
            });
        }).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "toggleVisibility.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)toggleVisibilityButton);
        class_4185 unignoreSlotsButton = class_4185.method_46430((class_2561)Localization.localized("editor", "unignoreSlots", new Object[0]), button -> this.ignoredSlots.clear()).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "unignoreSlots.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)unignoreSlotsButton);
        class_4185 moveToDefaultButton = class_4185.method_46430((class_2561)Localization.localized("editor", "moveToDefault", new Object[0]), button -> {
            Vec2i before = this.buttons.getFirst().offset;
            this.buttons.getFirst().offset = Config.options().layoutOffset;
            this.repositionButtons(this.buttons.getFirst(), before);
        }).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "moveToDefault.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)moveToDefaultButton);
        class_4185 saveAsDefaultButton = class_4185.method_46430((class_2561)Localization.localized("editor", "saveAsDefault", new Object[0]), button -> class_310.method_1551().method_1507((class_437)new class_410(confirm -> {
            if (confirm) {
                Config.options().layoutOffset = this.buttons.getFirst().offset;
                Config.save();
                this.method_25426();
            }
            class_310.method_1551().method_1507((class_437)this);
        }, (class_2561)Localization.localized("title", "confirm.saveAsDefault", new Object[0]), (class_2561)Localization.localized("message", "confirm.saveAsDefault", new Object[0])))).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "saveAsDefault.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)saveAsDefaultButton);
        class_4185 splitPolicyButton = class_4185.method_46430((class_2561)Localization.localized("editor", "splitPolicy", new Object[0]), button -> class_310.method_1551().method_1507((class_437)new class_410(confirm -> {
            if (confirm) {
                Config.options().classPolicies.put(this.lowestPolicyKey, new ClassPolicy(this.lowestPolicyKey, this.buttons.getFirst().offset, this.buttons.getFirst().operationAllowed ? (this.buttons.getFirst().field_22763 ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)1).operationAllowed ? (this.buttons.getFirst().field_22763 ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)2).operationAllowed ? (this.buttons.getFirst().field_22763 ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)3).operationAllowed ? (this.buttons.getFirst().field_22763 ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, new TreeSet<Integer>(this.ignoredSlots)));
                Config.save();
                this.method_25426();
            }
            class_310.method_1551().method_1507((class_437)this);
        }, (class_2561)Localization.localized("title", "confirm.splitPolicy", new Object[0]), (class_2561)Localization.localized("message", "confirm.splitPolicy", class_2561.method_43470((String)(this.rep.activePolicyKey == null ? this.lowestPolicyKey : this.rep.activePolicyKey)).method_27692(class_124.field_1065), class_2561.method_43470((String)this.lowestPolicyKey).method_27692(class_124.field_1065))))).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "splitPolicy.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        splitPolicyButton.field_22763 = this.rep.activePolicyKey != null && !this.rep.activePolicyKey.equals(this.lowestPolicyKey);
        this.method_37063((class_364)splitPolicyButton);
        class_4185 undoChangesButton = class_4185.method_46430((class_2561)Localization.localized("editor", "undoChanges", new Object[0]), button -> this.method_25426()).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "undoChanges.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)undoChangesButton);
        class_4185 reselectButton = class_4185.method_46430((class_2561)Localization.localized("editor", "reselect", new Object[0]), button -> {
            this.method_25419();
            class_310.method_1551().method_1507((class_437)new SelectorScreen(this.underlay, this));
        }).method_46436(class_7919.method_47407((class_2561)Localization.localized("editor", "reselect.tooltip", new Object[0]))).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)reselectButton);
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)cancelButton);
        class_4185 doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.saveAndClose()).method_46433(x, movingY += 21).method_46437(width, height).method_46431();
        this.method_37063((class_364)doneButton);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.underlay.method_25420(graphics, mouseX, mouseY, partialTick);
        this.underlay.method_25394(graphics, mouseX, mouseY, partialTick);
        ((GuiRenderStateAccessor)((GuiGraphicsAccessor)graphics).clientsort$getGuiRenderState()).clientsort$setFirstStratumAfterBlur(Integer.MAX_VALUE);
        graphics.method_71048();
        this.method_57734(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 2, -1);
        for (class_1735 slot : this.underlay.method_17577().field_7761) {
            Object object = ClientSort.getObj(slot, this.underlay.method_17577());
            if (object == null || !object.getClass().getName().equals(this.lowestPolicyKey) || !this.ignoredSlots.contains(((ISlot)slot).clientsort$getIndexInContainer())) continue;
            graphics.method_25303(class_310.method_1551().field_1772, "\u274c", ((AbstractContainerScreenAccessor)this.underlay).clientsort$getLeftPos() + slot.field_7873, ((AbstractContainerScreenAccessor)this.underlay).clientsort$getTopPos() + slot.field_7872, -65536);
        }
        if (this.buttons.isEmpty()) {
            return;
        }
        this.drawLineFor(graphics, this.buttons.getFirst());
        Vec2i offset = this.buttons.getFirst().offset;
        String string = Localization.localized("editor", "offset", offset.x(), offset.y()).getString();
        Objects.requireNonNull(this.field_22793);
        graphics.method_25303(this.field_22793, string, 105, this.field_22790 - (9 + 1) * 3, -1);
        class_5250 class_52502 = Localization.localized("editor", "policyKey.current", this.rep.activePolicyKey == null ? Localization.localized("editor", "policyKey.unset", new Object[0]) : this.rep.activePolicyKey);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)class_52502, 105, this.field_22790 - (9 + 1) * 2, -1);
        class_5250 class_52503 = Localization.localized("editor", "policyKey.menu", this.lowestPolicyKey);
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, (class_2561)class_52503, 105, this.field_22790 - (9 + 1), -1);
        for (TriggerButton cb : this.buttons) {
            cb.method_48579(graphics, mouseX, mouseY, partialTick);
        }
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (class_310.method_1551().field_1687 == null) {
            this.method_57728(graphics, partialTick);
        }
        this.method_57735(graphics);
    }

    protected void method_57734(@NotNull class_332 graphics) {
        int original = (Integer)class_310.method_1551().field_1690.method_57702().method_41753();
        class_310.method_1551().field_1690.method_57702().method_41748((Object)1);
        super.method_57734(graphics);
        class_310.method_1551().field_1690.method_57702().method_41748((Object)original);
    }

    private void drawLineFor(class_332 graphics, TriggerButton button) {
        graphics.method_51738(button.method_46426() - button.offset.x(), button.method_46426(), button.method_46427(), -4473925);
        graphics.method_51742(button.method_46426() - button.offset.x(), button.method_46427() - button.offset.y(), button.method_46427(), -4473925);
    }

    public void method_25419() {
        super.method_25419();
        this.lastScreen.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        class_310.method_1551().method_1507(this.lastScreen);
    }

    public void saveAndClose() {
        @Nullable Vec2i offset = this.buttons.getFirst().offset.equals(Config.options().layoutOffset) ? null : this.buttons.getFirst().offset;
        this.buttons.forEach(b -> b.savePolicy(offset, this.ignoredSlots));
        Config.save();
        this.method_25419();
    }

    public boolean method_25404(class_11908 event) {
        Vec2i movement;
        int distance = event.method_74239() ? 6 : 1;
        switch (event.comp_4795()) {
            case 263: {
                Vec2i vec2i = new Vec2i(-distance, 0);
                break;
            }
            case 262: {
                Vec2i vec2i = new Vec2i(distance, 0);
                break;
            }
            case 265: {
                Vec2i vec2i = new Vec2i(0, -distance);
                break;
            }
            case 264: {
                Vec2i vec2i = new Vec2i(0, distance);
                break;
            }
            default: {
                Vec2i vec2i = movement = null;
            }
        }
        if (movement != null) {
            Vec2i before = this.rep.offset;
            this.rep.offset = this.rep.offset.add(movement);
            this.repositionButtons(this.rep, before);
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (super.method_25402(event, doubleClick)) {
            this.dragging = false;
            return true;
        }
        for (TriggerButton cb : this.buttons) {
            if (!cb.method_25405(event.comp_4798(), event.comp_4799())) continue;
            cb.method_25402(event, doubleClick);
            this.rep = cb;
            this.dragging = true;
            return true;
        }
        for (class_1735 slot : this.underlay.method_17577().field_7761) {
            Object object;
            if (!((AbstractContainerScreenAccessor)this.underlay).clientsort$isHovering(slot, event.comp_4798(), event.comp_4799()) || (object = ClientSort.getObj(slot, this.underlay.method_17577())) == null || !object.getClass().getName().equals(this.lowestPolicyKey)) continue;
            int slotId = ((ISlot)slot).clientsort$getIndexInContainer();
            if (this.ignoredSlots.contains(slotId)) {
                this.ignoredSlots.remove(slotId);
                continue;
            }
            this.ignoredSlots.add(slotId);
        }
        return false;
    }

    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        if (this.dragging) {
            Vec2i before = this.rep.offset;
            if (this.rep.method_25403(event, dragX, dragY)) {
                this.repositionButtons(this.rep, before);
                return true;
            }
        }
        return super.method_25403(event, dragX, dragY);
    }

    public boolean method_25406(class_11909 event) {
        this.dragging = false;
        return super.method_25406(event);
    }

    private void repositionButtons(TriggerButton button, Vec2i before) {
        if (!button.offset.equals(before)) {
            Vec2i diff = button.offset.subtract(before);
            for (TriggerButton cb : this.buttons) {
                if (cb == button) continue;
                cb.offset = cb.offset.add(diff);
            }
        }
    }
}

