/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.compat.itemlocks.ItemLocksWrapper;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.gui.TriggerButtonManager;
import dev.terminalmc.clientsort.client.inventory.Scope;
import dev.terminalmc.clientsort.client.inventory.helper.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientCreativeOperator;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientSurvivalOperator;
import dev.terminalmc.clientsort.client.inventory.operator.server.ServerOperator;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.util.SlotLogUtil;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public abstract class SingleUseOperator {
    private boolean hasOperated = false;
    protected final class_465<?> screen;
    protected final ContainerScreenHelper<? extends class_465<?>> screenHelper;
    protected final Operation op;
    protected final class_1735 originSlot;
    protected final class_1735[] originScopeSlots;
    protected final class_1799[] originScopeStacks;
    protected final class_1735[] otherScopeSlots;
    protected final class_1799[] otherScopeStacks;

    protected SingleUseOperator(class_465<?> screen, class_1735 originSlot, Operation op) {
        class_1735 otherSlot;
        this.screen = screen;
        this.screenHelper = ContainerScreenHelper.of(screen);
        this.originSlot = originSlot;
        this.op = op;
        Scope originScope = this.screenHelper.getScope(originSlot);
        this.originScopeSlots = this.collectSlots(originSlot, originScope);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Discovered {} slots in origin scope ({} - {}):", this.originScopeSlots.length, originScope.ordinal(), originScope.name());
            dev.terminalmc.clientsort.client.ClientSort.LOG.info(SlotLogUtil.listSlotIds(List.of(this.originScopeSlots)), new Object[0]);
        }
        this.originScopeStacks = new class_1799[this.originScopeSlots.length];
        for (int i = 0; i < this.originScopeSlots.length; ++i) {
            this.originScopeStacks[i] = this.originScopeSlots[i].method_7677().method_7972();
        }
        class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
        class_1735 class_17352 = otherSlot = originSlot.field_7871 == player.method_31548() ? TriggerButtonManager.getContainerRefSlot(op) : TriggerButtonManager.getPlayerRefSlot(op);
        if (otherSlot == null || !op.isDirectional()) {
            this.otherScopeSlots = new class_1735[0];
            this.otherScopeStacks = new class_1799[0];
            return;
        }
        Scope otherScope = this.screenHelper.getScope(otherSlot);
        this.otherScopeSlots = this.collectSlots(otherSlot, otherScope);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Discovered {} slots in other scope ({} - {}):", this.otherScopeSlots.length, otherScope.ordinal(), otherScope.name());
            dev.terminalmc.clientsort.client.ClientSort.LOG.info(SlotLogUtil.listSlotIds(List.of(this.otherScopeSlots)), new Object[0]);
        }
        this.otherScopeStacks = new class_1799[this.otherScopeSlots.length];
        for (int i = 0; i < this.otherScopeSlots.length; ++i) {
            this.otherScopeStacks[i] = this.otherScopeSlots[i].method_7677().method_7972();
        }
    }

    private class_1735[] collectSlots(class_1735 refSlot, Scope scope) {
        class_746 player = class_310.method_1551().field_1724;
        if (scope == Scope.INVALID) {
            return new class_1735[0];
        }
        class_1799 testItem = class_1802.field_30904.method_7854();
        ArrayList<class_1735> collectedSlots = new ArrayList<class_1735>();
        for (class_1735 slot : this.screenHelper.getGroupForSlot(refSlot, scope)) {
            ClassPolicy policy;
            Object object;
            int slotId = ((ISlot)slot).clientsort$getIndexInMenu();
            int slotIdx = ((ISlot)slot).clientsort$getIndexInContainer();
            if (!slot.method_7681() ? !slot.field_7871.method_5437(slotId, testItem) || !slot.method_7680(testItem) : player != null && !slot.method_7674((class_1657)player)) continue;
            if (ItemLocksWrapper.isLocked(slot) || (object = ClientSort.getObj(slot, this.screen.method_17577())) == null || (policy = PolicyManager.getPolicy(object.getClass())) != null && policy.ignoredSlots().contains(slotIdx)) continue;
            collectedSlots.add(slot);
        }
        return collectedSlots.toArray(new class_1735[0]);
    }

    private boolean canOperate() {
        if (this.hasOperated) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.warn("{} can only be used once!", this.getClass().getSimpleName());
            return false;
        }
        this.hasOperated = true;
        return true;
    }

    public static boolean sort(class_465<?> screen, class_1735 originSlot, boolean onlyClient, SortOrder sortOrder) {
        if (sortOrder.equals(SortOrder.NONE)) {
            return false;
        }
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.SORT);
        if (op != null && op.canOperate()) {
            op.sort(sortOrder);
            return true;
        }
        return false;
    }

    public static boolean fillStacks(class_465<?> screen, class_1735 originSlot, boolean onlyClient) {
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.STACK_FILL);
        if (op != null && op.canOperate()) {
            op.fillStacks();
            return true;
        }
        return false;
    }

    public static boolean transferMatching(class_465<?> screen, class_1735 originSlot, boolean onlyClient) {
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.MATCH_TRANSFER);
        if (op != null && op.canOperate()) {
            op.matchTransfer();
            return true;
        }
        return false;
    }

    public static boolean transfer(class_465<?> screen, class_1735 originSlot, boolean onlyClient) {
        @Nullable SingleUseOperator op = SingleUseOperator.getOperator(screen, originSlot, onlyClient, Operation.TRANSFER);
        if (op != null && op.canOperate()) {
            op.transfer();
            return true;
        }
        return false;
    }

    @Nullable
    private static SingleUseOperator getOperator(class_465<?> screen, class_1735 originSlot, boolean onlyClient, Operation operation) {
        block15: {
            Object object = ClientSort.getObj(originSlot, screen.method_17577());
            if (object == null) {
                return null;
            }
            @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
            if (policy == null) break block15;
            switch (operation) {
                default: {
                    throw new MatchException(null, null);
                }
                case SORT: {
                    if (!policy.canSort()) break;
                    break block15;
                }
                case STACK_FILL: {
                    if (!policy.canStackFill()) break;
                    break block15;
                }
                case MATCH_TRANSFER: {
                    if (!policy.canMatchTransfer()) break;
                    break block15;
                }
                case TRANSFER: {
                    if (policy.canTransfer()) break block15;
                }
            }
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Operation {} is disallowed by policy for class {}!", operation.name(), policy.getClass());
            }
            return null;
        }
        if (!onlyClient && Config.options().useServerAcceleration && ClientServices.PLATFORM.canSendToServer(operation.type)) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing server operator for {}", operation.name());
            }
            return new ServerOperator(screen, originSlot, operation);
        }
        if (dev.terminalmc.clientsort.client.ClientSort.operatingClient) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Client operation is unavailable: another operation is in progress!", new Object[0]);
            }
            return null;
        }
        if (class_310.method_1551().field_1724.method_68878() && screen instanceof class_481) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing client-creative operator for {}", operation.name());
            }
            return new ClientCreativeOperator(screen, originSlot, operation);
        }
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing client-survival operator for {}", operation.name());
        }
        return new ClientSurvivalOperator(screen, originSlot, operation);
    }

    protected abstract void sort(SortOrder var1);

    protected abstract void fillStacks();

    protected abstract void matchTransfer();

    protected abstract void transfer();

    protected static class_1735[] collectMatchingSlots(class_1735[] originSlots, class_1799[] otherStacks, boolean alwaysMatchByType, Set<class_1792> typeMatchItems) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        for (class_1735 slot : originSlots) {
            if (!SingleUseOperator.containsMatchingStack(otherStacks, slot.method_7677(), alwaysMatchByType, typeMatchItems)) continue;
            slots.add(slot);
        }
        return slots.toArray(new class_1735[0]);
    }

    protected static boolean containsMatchingStack(class_1799[] stacks, class_1799 stack, boolean alwaysMatchByType, Set<class_1792> typeMatchItems) {
        for (class_1799 s : stacks) {
            if (!SingleUseOperator.stacksMatch(s, stack, alwaysMatchByType, typeMatchItems)) continue;
            return true;
        }
        return false;
    }

    protected static boolean stacksMatch(class_1799 a, class_1799 b, boolean alwaysMatchByType, Set<class_1792> typeMatchItems) {
        return class_1799.method_31577((class_1799)a, (class_1799)b) || class_1799.method_7984((class_1799)a, (class_1799)b) && (alwaysMatchByType || typeMatchItems.contains(a.method_7909()));
    }
}

