/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort;

import com.mojang.blaze3d.platform.InputConstants;
import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.sort.SortOrder;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.util.Localization;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class ClientSort {
    public static final KeyMapping SORT_KEY = new KeyMapping(Localization.translationKey("key", "group.sort"), InputConstants.Type.MOUSE, 2, Localization.translationKey("key", "group"));
    public static boolean searchOrderUpdated = false;
    public static volatile boolean emiReloading = false;
    public static volatile boolean updateBlockedByEmi = false;

    public static void init() {
        Config.getAndSave();
    }

    public static void onConfigSaved(Config config) {
        Config.Options options = config.options;
        options.sortOrder = SortOrder.SORT_MODES.get(options.sortOrderStr);
        options.shiftSortOrder = SortOrder.SORT_MODES.get(options.shiftSortOrderStr);
        options.ctrlSortOrder = SortOrder.SORT_MODES.get(options.ctrlSortOrderStr);
        options.altSortOrder = SortOrder.SORT_MODES.get(options.altSortOrderStr);
        options.sortSoundLoc = ResourceLocation.tryParse((String)options.sortSound);
        ClientSort.setInteractionManagerTickRate(config.options);
    }

    public static void setInteractionManagerTickRate(Config.Options options) {
        if (Minecraft.getInstance() == null || Minecraft.getInstance().getSingleplayerServer() == null) {
            InteractionManager.setTickRate(options.interactionRateServer);
        } else {
            InteractionManager.setTickRate(options.interactionRateClient);
        }
    }
}

