/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.inventory.sort.SortOrder;
import dev.terminalmc.clientsort.main.MainSort;
import dev.terminalmc.clientsort.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final Path CONFIG_DIR = Services.PLATFORM.getConfigDir();
    private static final String FILE_NAME = "clientsort.json";
    private static final String BACKUP_FILE_NAME = "clientsort.unreadable.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Options options = new Options();
    private static Config instance = null;

    public static Options options() {
        return Config.get().options;
    }

    private void validate() {
        this.update();
        if (this.options.interactionRateServer < 1) {
            this.options.interactionRateServer = 1;
        }
        if (this.options.interactionRateServer > 100) {
            this.options.interactionRateServer = 100;
        }
        if (this.options.interactionRateClient < 1) {
            this.options.interactionRateClient = 1;
        }
        if (this.options.interactionRateClient > 100) {
            this.options.interactionRateClient = 100;
        }
        if (this.options.soundRate < 1) {
            this.options.soundRate = 1;
        }
        if (this.options.soundRate > 100) {
            this.options.soundRate = 100;
        }
        if (this.options.soundMinPitch < 0.5f) {
            this.options.soundMinPitch = 0.5f;
        }
        if (this.options.soundMinPitch > 2.0f) {
            this.options.soundMinPitch = 2.0f;
        }
        if (this.options.soundMaxPitch < 0.5f) {
            this.options.soundMaxPitch = 0.5f;
        }
        if (this.options.soundMaxPitch > 2.0f) {
            this.options.soundMaxPitch = 2.0f;
        }
        if (this.options.soundMaxPitch < this.options.soundMinPitch) {
            this.options.soundMaxPitch = this.options.soundMinPitch;
        }
        if (this.options.soundVolume < 0.0f) {
            this.options.soundVolume = 0.0f;
        }
        if (this.options.soundVolume > 1.0f) {
            this.options.soundVolume = 1.0f;
        }
    }

    private void update() {
        if (this.options.hotbarMode != Options.hotbarModeDefault) {
            this.options.hotbarScope = this.options.hotbarMode.update();
            this.options.hotbarMode = Options.hotbarModeDefault;
        }
        if (this.options.extraSlotMode != Options.extraSlotModeDefault) {
            this.options.extraSlotScope = this.options.extraSlotMode.update();
            this.options.extraSlotMode = Options.extraSlotModeDefault;
        }
        if (!Options.sortOrderDefault.equals(this.options.sortModeStr)) {
            this.options.sortOrderStr = this.options.sortModeStr;
            this.options.sortModeStr = Options.sortOrderDefault;
        }
        if (!Options.shiftSortOrderDefault.equals(this.options.shiftSortModeStr)) {
            this.options.shiftSortOrderStr = this.options.shiftSortModeStr;
            this.options.shiftSortModeStr = Options.shiftSortOrderDefault;
        }
        if (!Options.ctrlSortOrderDefault.equals(this.options.ctrlSortModeStr)) {
            this.options.ctrlSortOrderStr = this.options.ctrlSortModeStr;
            this.options.ctrlSortModeStr = Options.ctrlSortOrderDefault;
        }
        if (!Options.altSortOrderDefault.equals(this.options.altSortModeStr)) {
            this.options.altSortOrderStr = this.options.altSortModeStr;
            this.options.altSortModeStr = Options.altSortOrderDefault;
        }
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = CONFIG_DIR.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0]) && (config = Config.load(file, GSON)) == null) {
            Config.backup();
            MainSort.LOG.warn("Resetting config", new Object[0]);
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MainSort.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup() {
        try {
            MainSort.LOG.warn("Copying {} to {}", FILE_NAME, BACKUP_FILE_NAME);
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(BACKUP_FILE_NAME);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            MainSort.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ClientSort.onConfigSaved(instance);
        }
        catch (IOException e) {
            MainSort.LOG.error("Unable to save config", e);
        }
    }

    public static class Options {
        public static final int interactionRateMin = 1;
        public static final int interactionRateMax = 100;
        public static final int interactionRateServerDefault = 10;
        public int interactionRateServer = 10;
        public static final int interactionRateClientDefault = 1;
        public int interactionRateClient = 1;
        public static final boolean serverAcceleratedSortingDefault = true;
        public boolean serverAcceleratedSorting = true;
        public static final boolean optimizedCreativeSortingDefault = true;
        public boolean optimizedCreativeSorting = true;
        public static final HotbarScope hotbarScopeDefault = HotbarScope.HOTBAR;
        public HotbarScope hotbarScope = hotbarScopeDefault;
        public static final ExtraSlotScope extraSlotScopeDefault = ExtraSlotScope.EXTRA;
        public ExtraSlotScope extraSlotScope = extraSlotScopeDefault;
        public static final boolean rmbBundleDefault = false;
        public boolean rmbBundle = false;
        public static final String sortOrderDefault = SortOrder.CREATIVE.name;
        public String sortOrderStr = sortOrderDefault;
        public transient SortOrder sortOrder;
        public static final String shiftSortOrderDefault = SortOrder.QUANTITY.name;
        public String shiftSortOrderStr = shiftSortOrderDefault;
        public transient SortOrder shiftSortOrder;
        public static final String ctrlSortOrderDefault = SortOrder.ALPHABET.name;
        public String ctrlSortOrderStr = ctrlSortOrderDefault;
        public transient SortOrder ctrlSortOrder;
        public static final String altSortOrderDefault = SortOrder.RAW_ID.name;
        public String altSortOrderStr = altSortOrderDefault;
        public transient SortOrder altSortOrder;
        public static final boolean soundEnabledDefault = false;
        public boolean soundEnabled = false;
        public static final String sortSoundDefault = "minecraft:block.note_block.xylophone";
        public String sortSound = "minecraft:block.note_block.xylophone";
        @Nullable
        public transient ResourceLocation sortSoundLoc = null;
        public static final int soundRateDefault = 1;
        public int soundRate = 1;
        public static final float soundPitchMin = 0.5f;
        public static final float soundPitchMax = 2.0f;
        public static final float soundMinPitchDefault = 0.5f;
        public float soundMinPitch = 0.5f;
        public static final float soundMaxPitchDefault = 2.0f;
        public float soundMaxPitch = 2.0f;
        public static final float soundVolumeMin = 0.0f;
        public static final float soundVolumeMax = 1.0f;
        public static final float soundVolumeDefault = 0.2f;
        public float soundVolume = 0.2f;
        public static final boolean soundAllowOverlapDefault = true;
        public boolean soundAllowOverlap = true;
        public static final HotbarMode hotbarModeDefault = HotbarMode.HARD;
        public HotbarMode hotbarMode = hotbarModeDefault;
        public static final ExtraSlotMode extraSlotModeDefault = ExtraSlotMode.NONE;
        public ExtraSlotMode extraSlotMode = extraSlotModeDefault;
        public String sortModeStr = sortOrderDefault;
        public String shiftSortModeStr = shiftSortOrderDefault;
        public String ctrlSortModeStr = ctrlSortOrderDefault;
        public String altSortModeStr = altSortOrderDefault;

        public static enum HotbarScope {
            HOTBAR,
            INVENTORY,
            NONE;

        }

        public static enum ExtraSlotScope {
            EXTRA,
            HOTBAR,
            INVENTORY,
            NONE;

        }

        public static enum HotbarMode {
            NONE,
            HARD,
            SOFT;


            public HotbarScope update() {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> HotbarScope.INVENTORY;
                    case 1 -> HotbarScope.HOTBAR;
                    case 2 -> HotbarScope.NONE;
                };
            }
        }

        public static enum ExtraSlotMode {
            NONE,
            HOTBAR,
            INVENTORY;


            public ExtraSlotScope update() {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> ExtraSlotScope.NONE;
                    case 1 -> ExtraSlotScope.HOTBAR;
                    case 2 -> ExtraSlotScope.INVENTORY;
                };
            }
        }
    }
}

