/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory;

import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.CreativeContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.Scope;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerScreenHelper<T extends AbstractContainerScreen<?>> {
    protected final T screen;
    protected final InteractionManager.ClickEventFactory clickEventFactory;

    protected ContainerScreenHelper(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        this.screen = screen;
        this.clickEventFactory = clickEventFactory;
    }

    public static <T extends AbstractContainerScreen<?>> ContainerScreenHelper<T> of(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        if (screen instanceof CreativeModeInventoryScreen) {
            return new CreativeContainerScreenHelper<CreativeModeInventoryScreen>((CreativeModeInventoryScreen)screen, clickEventFactory);
        }
        return new ContainerScreenHelper<T>(screen, clickEventFactory);
    }

    public InteractionManager.InteractionEvent createClickEvent(Slot slot, int action, ClickType actionType, boolean playSound) {
        return this.clickEventFactory.create(slot, action, actionType, playSound);
    }

    public boolean isHotbarSlot(Slot slot) {
        return ((ISlot)slot).clientSort$getIndexInInv() < 9;
    }

    public boolean isExtraSlot(Slot slot) {
        return ((ISlot)slot).clientSort$getIndexInInv() >= 40;
    }

    public Scope getScope(Slot slot) {
        if (!slot.mayPlace(ItemStack.EMPTY)) {
            return Scope.INVALID;
        }
        if (slot.container instanceof Inventory) {
            boolean mergeWithHotbar = false;
            if (this.isExtraSlot(slot)) {
                switch (Config.options().extraSlotScope) {
                    case HOTBAR: {
                        mergeWithHotbar = true;
                        break;
                    }
                    case EXTRA: {
                        return Scope.PLAYER_INV_EXTRA;
                    }
                    case NONE: {
                        return Scope.INVALID;
                    }
                }
            }
            if (mergeWithHotbar || this.isHotbarSlot(slot)) {
                switch (Config.options().hotbarScope) {
                    case HOTBAR: {
                        return Scope.PLAYER_INV_HOTBAR;
                    }
                    case NONE: {
                        return Scope.INVALID;
                    }
                }
            }
            return Scope.PLAYER_INV;
        }
        return Scope.CONTAINER_INV;
    }

    public void translateSlotMapping(int[] slotMapping) {
    }
}

