/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory;

import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.ContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.Scope;
import dev.terminalmc.clientsort.network.InteractionManager;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class CreativeContainerScreenHelper<T extends CreativeModeInventoryScreen>
extends ContainerScreenHelper<T> {
    public CreativeContainerScreenHelper(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        super(screen, clickEventFactory);
    }

    @Override
    public Scope getScope(Slot slot) {
        if (((CreativeModeInventoryScreen)this.screen).isInventoryOpen()) {
            return super.getScope(slot);
        }
        if (slot.container instanceof Inventory && this.isHotbarSlot(slot)) {
            return switch (Config.options().hotbarScope) {
                default -> throw new MatchException(null, null);
                case Config.Options.HotbarScope.HOTBAR, Config.Options.HotbarScope.INVENTORY -> Scope.PLAYER_INV_HOTBAR;
                case Config.Options.HotbarScope.NONE -> Scope.INVALID;
            };
        }
        return Scope.INVALID;
    }

    @Override
    public void translateSlotMapping(int[] slotMapping) {
        if (!((CreativeModeInventoryScreen)this.screen).isInventoryOpen()) {
            int i = 0;
            while (i < slotMapping.length) {
                int n = i++;
                slotMapping[n] = slotMapping[n] - 9;
            }
        }
    }
}

