/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory.sort;

import dev.terminalmc.clientsort.compat.itemlocks.ItemLocksWrapper;
import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.ContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.Scope;
import dev.terminalmc.clientsort.inventory.sort.SortContext;
import dev.terminalmc.clientsort.inventory.sort.SortOrder;
import dev.terminalmc.clientsort.main.MainSort;
import dev.terminalmc.clientsort.main.network.SortPayload;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.platform.Services;
import dev.terminalmc.clientsort.util.SoundManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class InventorySorter {
    private final ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper;
    private final AbstractContainerScreen<?> containerScreen;
    private final Slot[] inventorySlots;
    private final ItemStack[] stacks;

    public InventorySorter(ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper, AbstractContainerScreen<?> containerScreen, Slot originSlot) {
        this.screenHelper = screenHelper;
        this.containerScreen = containerScreen;
        this.inventorySlots = this.collectSlots(originSlot);
        this.stacks = new ItemStack[this.inventorySlots.length];
        for (int i = 0; i < this.inventorySlots.length; ++i) {
            this.stacks[i] = this.inventorySlots[i].getItem();
        }
    }

    private Slot[] collectSlots(Slot originSlot) {
        LocalPlayer player = Minecraft.getInstance().player;
        Scope originScope = this.screenHelper.getScope(originSlot);
        if (originScope == Scope.INVALID) {
            return new Slot[0];
        }
        ArrayList<Slot> collectedSlots = new ArrayList<Slot>();
        for (Slot slot : this.containerScreen.getMenu().slots) {
            if (originScope != this.screenHelper.getScope(slot) || player != null && !slot.mayPickup((Player)player) || ItemLocksWrapper.isLocked(slot)) continue;
            collectedSlots.add(slot);
        }
        return collectedSlots.toArray(new Slot[0]);
    }

    private void combineStacks() {
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.stacks.length - 1; i >= 0; --i) {
            int stackSize;
            ItemStack stack = this.stacks[i];
            if (stack.isEmpty() || (stackSize = stack.getCount()) >= stack.getItem().getDefaultMaxStackSize()) continue;
            clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, ClickType.PICKUP, false));
            for (int j = 0; j < i; ++j) {
                ItemStack target = this.stacks[j];
                if (target.isEmpty() || target.getCount() >= target.getItem().getDefaultMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)target)) continue;
                clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[j], 0, ClickType.PICKUP, false));
                int delta = target.getItem().getDefaultMaxStackSize() - target.getCount();
                delta = Math.min(delta, stackSize);
                target.setCount(target.getCount() + delta);
                if ((stackSize -= delta) <= 0) break;
            }
            if (clickEvents.size() <= 1) {
                clickEvents.clear();
                continue;
            }
            InteractionManager.pushAll(clickEvents);
            InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
            clickEvents.clear();
            if (stackSize > 0) {
                InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, ClickType.PICKUP, false));
                stack.setCount(stackSize);
                continue;
            }
            this.stacks[i] = ItemStack.EMPTY;
        }
    }

    public void sort(SortOrder sortOrder) {
        if (this.inventorySlots.length <= 1) {
            return;
        }
        this.combineStacks();
        int[] sortIds = new int[this.stacks.length];
        for (int i = 0; i < sortIds.length; ++i) {
            sortIds[i] = i;
        }
        SortContext context = new SortContext(this.containerScreen, Arrays.asList(this.inventorySlots));
        sortIds = sortOrder.sort(sortIds, this.stacks, context);
        if (Config.options().serverAcceleratedSorting && Services.PLATFORM.canSendToServer(SortPayload.TYPE)) {
            this.sortOnServer(sortIds);
        } else {
            boolean playSound;
            boolean bl = playSound = Config.options().soundEnabled && Config.options().soundVolume > 0.0f;
            if (playSound) {
                SoundManager.resetForCount(this.estimateMaxSounds());
            }
            this.sortOnClient(sortIds, playSound);
        }
    }

    protected void sortOnServer(int[] sortedIds) {
        int[] slotMapping = new int[sortedIds.length * 2];
        for (int i = 0; i < sortedIds.length; ++i) {
            Slot from = this.inventorySlots[sortedIds[i]];
            Slot to = this.inventorySlots[i];
            slotMapping[i * 2] = ((ISlot)from).clientSort$getIdInContainer();
            slotMapping[i * 2 + 1] = ((ISlot)to).clientSort$getIdInContainer();
        }
        this.screenHelper.translateSlotMapping(slotMapping);
        InteractionManager.push(() -> {
            Services.PLATFORM.sendToServer(new SortPayload(this.containerScreen.getMenu().containerId, slotMapping));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int estimateMaxSounds() {
        int stackCount = 0;
        for (ItemStack stack : this.stacks) {
            if (stack == ItemStack.EMPTY) continue;
            ++stackCount;
        }
        int compaction = 0;
        for (int i = 0; i < stackCount; ++i) {
            if (this.stacks[i] != ItemStack.EMPTY) continue;
            ++compaction;
        }
        int size = stackCount + compaction;
        size += size / 15;
        return size;
    }

    protected void sortOnClient(int[] sortedIds, boolean playSound) {
        int slotCount = this.stacks.length;
        int[] origin2Target = new int[slotCount];
        for (int i = 0; i < origin2Target.length; ++i) {
            origin2Target[sortedIds[i]] = i;
        }
        BitSet doneOrEmpty = new BitSet(slotCount * 2);
        for (int i = 0; i < slotCount; ++i) {
            if (i == sortedIds[i]) {
                doneOrEmpty.set(i);
                continue;
            }
            if (!this.stacks[i].isEmpty()) continue;
            doneOrEmpty.set(slotCount + i);
        }
        Item carriedItem = Items.AIR;
        Item[] backingStacks = (Item[])Arrays.stream((ItemStack[])this.stacks.clone()).map(ItemStack::getItem).toArray(Item[]::new);
        block2: for (int i = 0; i < slotCount; ++i) {
            if (doneOrEmpty.get(i)) continue;
            if (doneOrEmpty.get(slotCount + sortedIds[i])) {
                doneOrEmpty.set(sortedIds[i]);
                continue;
            }
            Item temp = backingStacks[sortedIds[i]];
            backingStacks[sortedIds[i]] = carriedItem;
            carriedItem = temp;
            InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[sortedIds[i]], 0, ClickType.PICKUP, playSound));
            doneOrEmpty.set(slotCount + sortedIds[i]);
            ItemStack currentStack = this.stacks[sortedIds[i]];
            Slot workingSlot = this.inventorySlots[sortedIds[i]];
            int id = i;
            do {
                if (this.stacks[id].getItem() == currentStack.getItem() && !doneOrEmpty.get(slotCount + id) && ItemStack.isSameItemSameComponents((ItemStack)this.stacks[id], (ItemStack)currentStack)) {
                    if (this.stacks[id].getCount() == currentStack.getCount()) {
                        doneOrEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                    if (currentStack.getCount() < this.stacks[id].getCount()) {
                        Slot targetSlot = this.inventorySlots[id];
                        temp = backingStacks[id];
                        backingStacks[id] = carriedItem;
                        carriedItem = temp;
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP, playSound));
                        currentStack = this.stacks[id];
                        doneOrEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                }
                if (!Config.options().rmbBundle && (backingStacks[id] instanceof BundleItem && !(carriedItem instanceof AirItem) || carriedItem instanceof BundleItem && !(backingStacks[id] instanceof AirItem))) {
                    InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[id], 1, ClickType.PICKUP, playSound));
                } else {
                    InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[id], 0, ClickType.PICKUP, playSound));
                }
                temp = backingStacks[id];
                backingStacks[id] = carriedItem;
                carriedItem = temp;
                currentStack = this.stacks[id];
                doneOrEmpty.set(id);
                if (doneOrEmpty.get(slotCount + id)) continue block2;
                id = origin2Target[id];
            } while (!doneOrEmpty.get(id));
        }
    }

    private static void logInventorySlots(Slot[] inventorySlots) {
        StringBuilder arr = new StringBuilder("[");
        for (Slot inventorySlot : inventorySlots) {
            arr.append(inventorySlot.index);
            arr.append(":");
            arr.append(inventorySlot.getItem().getDisplayName().getString());
            arr.append(", ");
        }
        MainSort.LOG.warn((String)(arr.length() == 1 ? "[]" : arr.substring(0, arr.length() - 2) + "]"), new Object[0]);
    }
}

