/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.main.network;

import dev.terminalmc.clientsort.main.MainSort;
import dev.terminalmc.clientsort.main.network.SortPayload;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LogicalServerNetworking {
    private LogicalServerNetworking() {
    }

    public static void onSortPayload(SortPayload payload, MinecraftServer server, ServerPlayer player) {
        if (player.containerMenu == null) {
            MainSort.LOG.warn("Player {} tried to sort inventory without having an open container!", player);
            return;
        }
        if (payload.syncId() == player.inventoryMenu.containerId) {
            server.execute(() -> LogicalServerNetworking.sort((Player)player, (AbstractContainerMenu)player.inventoryMenu, payload.slotMapping()));
        } else if (payload.syncId() == player.containerMenu.containerId) {
            server.execute(() -> LogicalServerNetworking.sort((Player)player, player.containerMenu, payload.slotMapping()));
        }
    }

    private static void sort(Player player, AbstractContainerMenu screenHandler, int[] slotMapping) {
        TreeMap<Integer, Slot> slots = new TreeMap<Integer, Slot>();
        TreeMap<Integer, ItemStack> stacks = new TreeMap<Integer, ItemStack>();
        for (Slot slot : screenHandler.slots) {
            slots.put(slot.index, slot);
            stacks.put(slot.index, slot.getItem());
        }
        if (!LogicalServerNetworking.validMapping(player, slots, slotMapping)) {
            MainSort.LOG.warn("Sort payload from player {} contains invalid data, ignoring!", player);
            return;
        }
        for (int i = 0; i < slotMapping.length - 1; i += 2) {
            int originSlotId = slotMapping[i];
            int destSlotId = slotMapping[i + 1];
            ((Slot)slots.get(destSlotId)).setByPlayer((ItemStack)stacks.get(originSlotId));
        }
    }

    private static boolean validMapping(Player player, Map<Integer, Slot> slots, int[] slotMapping) {
        int i;
        if (slotMapping.length < 4) {
            MainSort.LOG.warn("Sort payload contains too few slots! Got {}, expected at least {}", slotMapping.length, 4);
            return false;
        }
        IntAVLTreeSet requestedSlots = new IntAVLTreeSet();
        if (!LogicalServerNetworking.validSlotId(slots, slotMapping[0])) {
            return false;
        }
        Slot firstSlot = slots.get(slotMapping[0]);
        Container targetInv = firstSlot.container;
        for (i = 0; i < slotMapping.length; i += 2) {
            int originSlotId = slotMapping[i];
            int destSlotId = slotMapping[i + 1];
            if (!LogicalServerNetworking.validSlot(slots, originSlotId, targetInv)) {
                return false;
            }
            if (!requestedSlots.add(originSlotId)) {
                MainSort.LOG.warn("Sort payload contains duplicate origin slot {}!", originSlotId);
                return false;
            }
            if (!LogicalServerNetworking.validSlot(slots, destSlotId, targetInv)) {
                return false;
            }
            if (originSlotId == destSlotId) continue;
            Slot originSlot = slots.get(originSlotId);
            if (!originSlot.mayPickup(player)) {
                MainSort.LOG.warn("Player {} tried to sort slot {} with stack [{}], but that slot doesn't allow taking items!", player, originSlotId, originSlot.getItem());
                return false;
            }
            Slot destSlot = slots.get(destSlotId);
            if (destSlot.mayPlace(originSlot.getItem())) continue;
            MainSort.LOG.warn("Player {} tried to sort slot {} with stack [{}], but that slot doesn't allow inserting the origin stack [{}]!", player, destSlotId, destSlot.getItem(), originSlot.getItem());
            return false;
        }
        for (i = 1; i < slotMapping.length; i += 2) {
            int destSlotId = slotMapping[i];
            if (requestedSlots.remove(destSlotId)) continue;
            MainSort.LOG.warn("Sort payload contains duplicate destination slot or slot without origin: {}!", i);
            return false;
        }
        if (!requestedSlots.isEmpty()) {
            MainSort.LOG.error("Invalid state during checking sort payload, please report this to the {} developer. Requested slots: {}", "ClientSort", requestedSlots);
            return false;
        }
        return true;
    }

    private static boolean validSlotId(Map<Integer, Slot> slots, int slotId) {
        if (!slots.containsKey(slotId)) {
            StringBuilder sb = new StringBuilder();
            slots.keySet().forEach(key -> sb.append(key).append(", "));
            MainSort.LOG.warn("Sort payload contains invalid slot id {} not found in list [{}]!", slotId, sb.toString());
            return false;
        }
        return true;
    }

    private static boolean validSlot(Map<Integer, Slot> slots, int slotId, Container targetInv) {
        if (!LogicalServerNetworking.validSlotId(slots, slotId)) {
            return false;
        }
        Slot slot = slots.get(slotId);
        if (targetInv != slot.container) {
            MainSort.LOG.warn("Sort payload contains slots from different inventories, first: {}, now: {}!", targetInv, slot.container);
            return false;
        }
        return true;
    }

    private static void logScreenHandlerSlots(AbstractContainerMenu screenHandler) {
        StringBuilder arr = new StringBuilder("[");
        for (Slot slot : screenHandler.slots) {
            arr.append(slot.index);
            arr.append(":");
            arr.append(slot.getItem().getDisplayName().getString());
            arr.append(", ");
        }
        MainSort.LOG.warn((String)(arr.length() == 1 ? "[]" : arr.substring(0, arr.length() - 2) + "]"), new Object[0]);
    }

    private static void logSlotMapping(int[] slotMapping) {
        StringBuilder arr = new StringBuilder("[");
        for (int i = 0; i < slotMapping.length - 1; i += 2) {
            arr.append(slotMapping[i]);
            arr.append("->");
            arr.append(slotMapping[i + 1]);
            arr.append(", ");
        }
        MainSort.LOG.warn((String)(arr.length() == 1 ? "[]" : arr.substring(0, arr.length() - 2) + "]"), new Object[0]);
    }
}

