/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.mixin;

import com.google.common.base.Suppliers;
import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.ContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.InventorySorter;
import dev.terminalmc.clientsort.inventory.sort.SortOrder;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.util.SoundManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class MixinAbstractContainerScreen
extends Screen {
    @Shadow
    @Final
    protected AbstractContainerMenu menu;
    @Shadow
    protected Slot hoveredSlot;
    @Shadow
    private ItemStack draggingItem;
    @Unique
    private final Supplier<ContainerScreenHelper<AbstractContainerScreen<AbstractContainerMenu>>> clientSort$screenHelper = Suppliers.memoize(() -> ContainerScreenHelper.of((AbstractContainerScreen)this, (slot, data, slotActionType, sound) -> new InteractionManager.CallbackEvent(() -> {
        this.slotClicked(slot, ((ISlot)slot).clientSort$getIdInContainer(), data, slotActionType);
        if (sound) {
            SoundManager.play();
        }
        return InteractionManager.TICK_WAITER;
    })));

    protected MixinAbstractContainerScreen(Component title) {
        super(title);
    }

    @Shadow
    protected abstract void slotClicked(Slot var1, int var2, int var3, ClickType var4);

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.clientSort$shouldSort(keyMapping -> keyMapping.matchesMouse(button)) && this.clientSort$triggerSort()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.clientSort$shouldSort(keyMapping -> keyMapping.matches(keyCode, scanCode)) && this.clientSort$triggerSort()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Unique
    private boolean clientSort$shouldSort(Function<KeyMapping, Boolean> inputMatcher) {
        if (this.hoveredSlot == null) {
            return false;
        }
        if (!inputMatcher.apply(ClientSort.SORT_KEY).booleanValue()) {
            return false;
        }
        Options options = this.minecraft.options;
        if (inputMatcher.apply(options.keyPickItem).booleanValue() && this.minecraft.player.hasInfiniteMaterials() && (this.hoveredSlot.hasItem() || !this.draggingItem.isEmpty() || !this.menu.getCarried().isEmpty())) {
            return false;
        }
        if (inputMatcher.apply(options.keyDrop).booleanValue() && this.hoveredSlot.hasItem()) {
            return false;
        }
        if (inputMatcher.apply(options.keySwapOffhand).booleanValue()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (!inputMatcher.apply(options.keyHotbarSlots[i]).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Unique
    public boolean clientSort$triggerSort() {
        if (this.hoveredSlot == null) {
            return false;
        }
        SortOrder sortOrder = MixinAbstractContainerScreen.hasShiftDown() ? Config.options().shiftSortOrder : (MixinAbstractContainerScreen.hasControlDown() ? Config.options().ctrlSortOrder : (MixinAbstractContainerScreen.hasAltDown() ? Config.options().altSortOrder : Config.options().sortOrder));
        if (sortOrder != null && sortOrder != SortOrder.NONE) {
            InventorySorter sorter = new InventorySorter(this.clientSort$screenHelper.get(), (AbstractContainerScreen)this, this.hoveredSlot);
            sorter.sort(sortOrder);
            return true;
        }
        return false;
    }
}

