/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.util;

import dev.terminalmc.clientsort.config.Config;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    private static long time = Long.MIN_VALUE;
    private static float pitch = 1.0f;
    private static float increment = 0.01f;
    @Nullable
    private static SoundInstance sound;

    public static void resetForCount(int size) {
        increment = (Config.options().soundMaxPitch - Config.options().soundMinPitch) / (float)size;
        pitch = Config.options().soundMinPitch;
    }

    private static float pitch() {
        float val = pitch;
        if ((pitch += increment) > Config.options().soundMaxPitch) {
            pitch = Config.options().soundMaxPitch;
        }
        return val;
    }

    public static void play() {
        long now = Util.getMillis();
        float soundPitch = SoundManager.pitch();
        if (now >= time) {
            time = now + (long)Config.options().soundRate;
            ResourceLocation location = Config.options().sortSoundLoc;
            if (location != null) {
                if (sound != null && !Config.options().soundAllowOverlap) {
                    Minecraft.getInstance().getSoundManager().stop(sound);
                }
                sound = new SimpleSoundInstance(location, SoundSource.MASTER, Config.options().soundVolume, soundPitch, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
                Minecraft.getInstance().getSoundManager().play(sound);
            }
        }
    }
}

