/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.util.item;

import com.google.common.base.Objects;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackMatcher {
    @NotNull
    private final Item item;
    @Nullable
    private final DataComponentMap components;

    private StackMatcher(@NotNull Item item, @Nullable DataComponentMap components) {
        this.item = item;
        this.components = components;
    }

    public static StackMatcher ignoreNbt(@NotNull ItemStack stack) {
        return new StackMatcher(stack.getItem(), null);
    }

    public static StackMatcher of(@NotNull ItemStack stack) {
        return new StackMatcher(stack.getItem(), stack.getComponents());
    }

    public boolean equals(Object obj) {
        if (obj instanceof StackMatcher) {
            StackMatcher matcher = (StackMatcher)obj;
            return ItemStack.isSameItemSameComponents((ItemStack)this.item.getDefaultInstance(), (ItemStack)matcher.item.getDefaultInstance());
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return ItemStack.isSameItem((ItemStack)this.item.getDefaultInstance(), (ItemStack)stack);
        }
        if (obj instanceof Item) {
            Item objItem = (Item)obj;
            return this.item == objItem;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.item, this.components});
    }
}

