/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.server;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.network.handler.CollectResultHandler;
import dev.terminalmc.clientsort.client.network.handler.SortResultHandler;
import dev.terminalmc.clientsort.client.network.handler.StackFillResultHandler;
import dev.terminalmc.clientsort.client.network.handler.TransferResultHandler;
import dev.terminalmc.clientsort.client.order.SortContext;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.network.payload.CollectPayload;
import dev.terminalmc.clientsort.network.payload.SortPayload;
import dev.terminalmc.clientsort.network.payload.StackFillPayload;
import dev.terminalmc.clientsort.network.payload.TransferPayload;
import dev.terminalmc.clientsort.util.Localization;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class ServerOperator<T extends Operation>
extends SingleUseOperator<Operation> {
    public ServerOperator(class_465<?> screen, ContainerScreenHelper<? extends class_465<?>> screenHelper, class_1735 originSlot, T operation) {
        super(screen, screenHelper, originSlot, operation);
    }

    @Override
    protected void sort(SortOrder sortOrder) {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        CollectResultHandler.onCompletion = collectResult -> {
            if (collectResult.isSuccess()) {
                SortResultHandler.onCompletion = sortResult -> {
                    if (!sortResult.isSuccess()) {
                        if (sortResult.isUnknown() || !Config.options().useClientFallback) {
                            this.setOverlayMessage((class_2561)class_2561.method_43471((String)sortResult.translationKey));
                        } else {
                            SingleUseOperator<Operation> operator = SingleUseOperator.getOperator(this.screen, this.screenHelper, this.originSlot, Operation.SORT, true);
                            if (operator != null) {
                                operator.trySort(sortOrder);
                            }
                        }
                    }
                };
                ServerOperator<Operation> sorter = new ServerOperator<Operation>(this.screen, this.screenHelper, this.originSlot, Operation.SORT);
                int[] slotMapping = sorter.createSlotMapping(sortOrder);
                InteractionManager.now(() -> {
                    if (ClientSort.debug()) {
                        dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation SORT", new Object[0]);
                    }
                    ClientServices.PLATFORM.sendToServer(new SortPayload(this.screen.method_17577().field_7763, slotMapping));
                    return InteractionManager.TICK_WAITER;
                });
            } else if (collectResult.isUnknown() || !Config.options().useClientFallback) {
                this.setOverlayMessage((class_2561)class_2561.method_43471((String)collectResult.translationKey));
            } else {
                SingleUseOperator<Operation> operator = SingleUseOperator.getOperator(this.screen, this.screenHelper, this.originSlot, Operation.SORT, true);
                if (operator != null) {
                    operator.trySort(sortOrder);
                }
            }
        };
        int[] scopeArray = this.createSlotIdArray(this.originScopeSlots);
        this.sendCollectPayload(scopeArray);
    }

    @Override
    protected void fillStacks() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation STACK_FILL: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation STACK_FILL: other scope is empty!", new Object[0]);
            }
            return;
        }
        StackFillResultHandler.onCompletion = result -> {
            if (!result.isSuccess()) {
                if (result.isUnknown() || !Config.options().useClientFallback) {
                    this.setOverlayMessage((class_2561)class_2561.method_43471((String)result.translationKey));
                } else {
                    SingleUseOperator<Operation> operator = SingleUseOperator.getOperator(this.screen, this.screenHelper, this.originSlot, Operation.STACK_FILL, true);
                    if (operator != null) {
                        operator.tryFillStacks();
                    }
                }
            }
        };
        int[] srcSlotIds = this.createSlotIdArray(this.originScopeSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        InteractionManager.now(() -> {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation STACK_FILL", new Object[0]);
            }
            ClientServices.PLATFORM.sendToServer(new StackFillPayload(this.screen.method_17577().field_7763, srcSlotIds, dstSlotIds));
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void matchTransfer() {
        this.transfer(ServerOperator.collectMatchingSlots(this.originScopeSlots, this.otherScopeStacks, Config.options().alwaysMatchByType, Config.options().typeMatchItemCache));
    }

    @Override
    protected void transfer() {
        this.transfer(null);
    }

    private void transfer(@Nullable class_1735[] overrideSlots) {
        class_1735[] originSlots;
        class_1735[] class_1735Array = originSlots = overrideSlots != null ? overrideSlots : this.originScopeSlots;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation TRANSFER: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (originSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation TRANSFER: origin slots is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform operation TRANSFER: other scope is empty!", new Object[0]);
            }
            return;
        }
        TransferResultHandler.onCompletion = result -> {
            if (!result.isSuccess()) {
                if (result.isUnknown() || !Config.options().useClientFallback) {
                    this.setOverlayMessage((class_2561)class_2561.method_43471((String)result.translationKey));
                } else {
                    SingleUseOperator<Operation> operator = SingleUseOperator.getOperator(this.screen, this.screenHelper, this.originSlot, overrideSlots != null ? Operation.MATCH_TRANSFER : Operation.TRANSFER, true);
                    if (operator != null) {
                        if (overrideSlots != null) {
                            this.tryMatchTransfer();
                        } else {
                            this.tryTransfer();
                        }
                    }
                }
            }
        };
        int[] srcSlotIds = this.createSlotIdArray(originSlots);
        int[] dstSlotIds = this.createSlotIdArray(this.otherScopeSlots);
        InteractionManager.now(() -> {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation TRANSFER", new Object[0]);
            }
            ClientServices.PLATFORM.sendToServer(new TransferPayload(this.screen.method_17577().field_7763, srcSlotIds, dstSlotIds));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int[] createSlotIdArray(class_1735[] slots) {
        int[] slotIds = new int[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            slotIds[i] = ((ISlot)slots[i]).clientsort$getIndexInMenu();
        }
        this.screenHelper.translateSlotIds(slotIds);
        return slotIds;
    }

    private void sendCollectPayload(int[] scopeArray) {
        InteractionManager.now(() -> {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Sending payload for operation COLLECT", new Object[0]);
            }
            ClientServices.PLATFORM.sendToServer(new CollectPayload(this.screen.method_17577().field_7763, scopeArray));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int[] createSlotMapping(SortOrder sortOrder) {
        int[] sortedIds = new int[this.originScopeStacks.length];
        for (int i = 0; i < sortedIds.length; ++i) {
            sortedIds[i] = i;
        }
        sortedIds = sortOrder.sort(sortedIds, this.originScopeStacks, new SortContext((class_1937)class_310.method_1551().field_1687));
        int[] slotMapping = new int[sortedIds.length * 2];
        for (int i = 0; i < sortedIds.length; ++i) {
            class_1735 from = this.originScopeSlots[sortedIds[i]];
            class_1735 to = this.originScopeSlots[i];
            slotMapping[i * 2] = ((ISlot)from).clientsort$getIndexInMenu();
            slotMapping[i * 2 + 1] = ((ISlot)to).clientsort$getIndexInMenu();
        }
        this.screenHelper.translateSlotIds(slotMapping);
        return slotMapping;
    }

    private void setOverlayMessage(class_2561 message) {
        dev.terminalmc.clientsort.client.ClientSort.setOverlayMessage(this.screen, (class_2561)Localization.localized("name", new Object[0]).method_27692(class_124.field_1061).method_27693("\n").method_10852(message).method_27693("\n").method_10852((class_2561)Localization.localized("message", "checkLogs", new Object[0])), 100);
    }
}

