/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.screen;

import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.inventory.screen.CreativeContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.util.Scope;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_465;
import net.minecraft.class_481;

public class ContainerScreenHelper<T extends class_465<?>> {
    protected final T screen;
    protected final InteractionManager.ClickEventFactory clickEventFactory;

    protected ContainerScreenHelper(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        this.screen = screen;
        this.clickEventFactory = clickEventFactory;
    }

    public static <T extends class_465<?>> ContainerScreenHelper<T> of(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        if (screen instanceof class_481) {
            return new CreativeContainerScreenHelper<class_481>((class_481)screen, clickEventFactory);
        }
        return new ContainerScreenHelper<T>(screen, clickEventFactory);
    }

    public static <T extends class_465<?>> ContainerScreenHelper<T> of(T screen) {
        InteractionManager.ClickEventFactory clickEventFactory = (slot, mouseButton, clickType, playSound) -> new InteractionManager.CallbackEvent(() -> {
            ((AbstractContainerScreenAccessor)screen).clientsort$slotClicked(slot, ((ISlot)slot).clientsort$getIndexInMenu(), mouseButton, clickType);
            if (playSound) {
                SoundManager.play();
            }
            return InteractionManager.TICK_WAITER;
        });
        return ContainerScreenHelper.of(screen, clickEventFactory);
    }

    public InteractionManager.InteractionEvent createClickEvent(class_1735 slot, int button, class_1713 clickType, boolean playSound) {
        return this.clickEventFactory.create(slot, button, clickType, playSound);
    }

    public boolean isHotbarSlot(class_1735 slot) {
        return ((ISlot)slot).clientsort$getIndexInContainer() < 9;
    }

    public boolean isExtraSlot(class_1735 slot) {
        return ((ISlot)slot).clientsort$getIndexInContainer() > 35;
    }

    public Scope getScope(class_1735 slot) {
        if (slot.field_7871 instanceof class_1661) {
            boolean mergeWithHotbar = false;
            if (this.isExtraSlot(slot)) {
                switch (Config.options().extraSlotScope) {
                    case HOTBAR: {
                        mergeWithHotbar = true;
                        break;
                    }
                    case EXTRA: {
                        return Scope.PLAYER_INV_EXTRA;
                    }
                    case NONE: {
                        return Scope.INVALID;
                    }
                }
            }
            if (mergeWithHotbar || this.isHotbarSlot(slot)) {
                switch (Config.options().hotbarScope) {
                    case HOTBAR: {
                        return Scope.PLAYER_INV_HOTBAR;
                    }
                    case NONE: {
                        return Scope.INVALID;
                    }
                }
            }
            return Scope.PLAYER_INV;
        }
        return Scope.CONTAINER_INV;
    }

    public void translateSlotIds(int[] slotMapping) {
    }
}

