/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.mixin.client;

import com.google.common.base.Suppliers;
import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.gui.screen.edit.EditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.util.KeybindManager;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin<T extends class_1703>
extends class_437 {
    @Shadow
    @Final
    protected class_1703 field_2797;
    @Shadow
    protected class_1735 field_2787;
    @Shadow
    private class_1799 field_2782;
    @Unique
    private final Supplier<ContainerScreenHelper<class_465<class_1703>>> clientsort$screenHelper = Suppliers.memoize(() -> ContainerScreenHelper.of((class_465)this, (slot, mouseButton, clickType, playSound) -> new InteractionManager.CallbackEvent(() -> {
        this.method_2383(slot, ((ISlot)slot).clientsort$getIndexInMenu(), mouseButton, clickType);
        if (playSound) {
            SoundManager.play();
        }
        return InteractionManager.TICK_WAITER;
    })));

    protected AbstractContainerScreenMixin(class_2561 title) {
        super(title);
    }

    @Shadow
    protected abstract void method_2383(class_1735 var1, int var2, int var3, class_1713 var4);

    @Shadow
    public abstract T method_17577();

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeSlotClicked(class_1735 slot, int slotId, int mouseButton, class_1713 type, CallbackInfo ci) {
        if (slotId < 0 && dev.terminalmc.clientsort.client.ClientSort.operatingClient) {
            ci.cancel();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Supplier<Boolean> op = this.clientsort$getOperation(keyMapping -> keyMapping.method_1433(button));
        if (op != null && op.get().booleanValue()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        Supplier<Boolean> op = this.clientsort$getOperation(keyMapping -> keyMapping.method_1417(keyCode, scanCode));
        if (op != null && op.get().booleanValue()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Unique
    @Nullable
    private Supplier<Boolean> clientsort$getOperation(Function<class_304, Boolean> inputMatcher) {
        boolean isEditKey = inputMatcher.apply(KeybindManager.EDIT_KEY);
        if (!isEditKey && this.field_2787 == null) {
            return null;
        }
        class_315 options = this.field_22787.field_1690;
        if (inputMatcher.apply(options.field_1871).booleanValue() && this.field_22787.field_1761.method_2914() && (this.field_2787.method_7681() || !this.field_2782.method_7960() || !this.field_2797.method_34255().method_7960())) {
            return null;
        }
        if (inputMatcher.apply(options.field_1869).booleanValue() && this.field_2787.method_7681()) {
            return null;
        }
        if (inputMatcher.apply(options.field_1831).booleanValue()) {
            return null;
        }
        for (int i = 0; i < 9; ++i) {
            if (!inputMatcher.apply(options.field_1852[i]).booleanValue()) continue;
            return null;
        }
        if (isEditKey) {
            return this::clientsort$openEditor;
        }
        if (inputMatcher.apply(KeybindManager.SORT_KEY).booleanValue()) {
            return this::clientsort$sort;
        }
        if (inputMatcher.apply(KeybindManager.STACK_FILL_KEY).booleanValue()) {
            return this::clientsort$fillStacks;
        }
        if (inputMatcher.apply(KeybindManager.MATCH_TRANSFER_KEY).booleanValue()) {
            return this::clientsort$matchTransfer;
        }
        if (inputMatcher.apply(KeybindManager.TRANSFER_KEY).booleanValue()) {
            return this::clientsort$transfer;
        }
        return null;
    }

    @Unique
    private boolean clientsort$openEditor() {
        class_310.method_1551().method_1507((class_437)new SelectorScreen((class_465)this));
        return true;
    }

    @Unique
    private boolean clientsort$sort() {
        if (this.field_2787 == null) {
            return false;
        }
        SortOrder sortOrder = AbstractContainerScreenMixin.method_25442() ? Config.options().shiftSortOrder : (AbstractContainerScreenMixin.method_25441() ? Config.options().ctrlSortOrder : (AbstractContainerScreenMixin.method_25443() ? Config.options().altSortOrder : Config.options().sortOrder));
        if (sortOrder != null && sortOrder != SortOrder.NONE) {
            SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((class_465)this, this.clientsort$screenHelper.get(), this.field_2787, Operation.SORT, false);
            if (operator != null) {
                operator.trySort(sortOrder);
            }
            return true;
        }
        return false;
    }

    @Unique
    private boolean clientsort$fillStacks() {
        SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((class_465)this, this.clientsort$screenHelper.get(), this.field_2787, Operation.STACK_FILL, false);
        if (operator != null) {
            operator.tryFillStacks();
        }
        return true;
    }

    @Unique
    private boolean clientsort$matchTransfer() {
        SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((class_465)this, this.clientsort$screenHelper.get(), this.field_2787, Operation.MATCH_TRANSFER, false);
        if (operator != null) {
            operator.tryMatchTransfer();
        }
        return true;
    }

    @Unique
    private boolean clientsort$transfer() {
        SingleUseOperator<Operation> operator = SingleUseOperator.getOperator((class_465)this, this.clientsort$screenHelper.get(), this.field_2787, Operation.TRANSFER, false);
        if (operator != null) {
            operator.tryTransfer();
        }
        return true;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void afterRender(class_332 graphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!((Object)((Object)this)).equals(class_310.method_1551().field_1755)) {
            return;
        }
        if (dev.terminalmc.clientsort.client.ClientSort.overlayMessage != null) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
            dev.terminalmc.clientsort.client.ClientSort.overlayMessage.method_48579(graphics, mouseX, mouseY, partialTick);
            graphics.method_51448().method_22909();
        }
        if (!ClientSort.debug()) {
            return;
        }
        ContainerScreenHelper<class_465> helper = ContainerScreenHelper.of((class_465)this, (a, b, c, d) -> null);
        float scale = 0.7f;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
        graphics.method_51448().method_22905(scale, scale, 0.0f);
        for (class_1735 slot : this.field_2797.field_7761) {
            int slotId = ((ISlot)slot).clientsort$getIndexInMenu();
            if (!(class_310.method_1551().field_1755 instanceof EditorScreen)) {
                Object object = dev.terminalmc.clientsort.client.ClientSort.getObj(slot, this.method_17577());
                if (object == null) continue;
                @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
                if (policy != null && policy.ignoredSlots().contains(slotId)) {
                    graphics.method_25303(class_310.method_1551().field_1772, "\u274c", (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.field_7873) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.field_7872) / scale), 0xFF0000);
                }
            }
            if (AbstractContainerScreenMixin.method_25442()) {
                slotId = ((ISlot)slot).clientsort$getIndexInContainer();
            } else if (AbstractContainerScreenMixin.method_25441()) {
                slotId = slot.method_34266();
            }
            graphics.method_25303(class_310.method_1551().field_1772, String.valueOf(slotId), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.field_7873) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.field_7872 + 12) / scale), 0xFFFFFF);
            graphics.method_25303(class_310.method_1551().field_1772, String.valueOf(helper.getScope(slot).ordinal()), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.field_7873 + 12) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.field_7872 + 12) / scale), 0xFFFFFF);
        }
        graphics.method_51448().method_22909();
    }
}

