/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.command.Commands;
import dev.terminalmc.clientsort.network.Registration;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="clientsort")
@EventBusSubscriber(modid="clientsort")
public class ClientSortNeoForge {
    public ClientSortNeoForge() {
        ClientSort.init();
    }

    @SubscribeEvent
    static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").optional();
        Registration.PAYLOADS_C2S.forEach(rp -> ClientSortNeoForge.registerC2S(registrar, rp));
    }

    private static <T extends CustomPacketPayload> void registerC2S(PayloadRegistrar registrar, Registration.RegisterablePayloadC2S<T> rp) {
        registrar.playToServer(rp.type, rp.streamCodec, (payload, context) -> rp.handler.accept(payload, context.player().getServer(), (ServerPlayer)context.player()));
    }

    private static <T extends CustomPacketPayload> void registerPayloadS2C(PayloadRegistrar registrar, Registration.RegisterablePayloadS2C<T> rp) {
        registrar.playToClient(rp.type, rp.streamCodec, (payload, context) -> {});
    }

    @EventBusSubscriber(modid="clientsort", value={Dist.DEDICATED_SERVER})
    static class DedicatedServerEventHandler {
        DedicatedServerEventHandler() {
        }

        @SubscribeEvent
        static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1").optional();
            Registration.PAYLOADS_S2C.forEach(rp -> ClientSortNeoForge.registerPayloadS2C(registrar, rp));
        }
    }

    @EventBusSubscriber(modid="clientsort")
    static class GameEventHandler {
        GameEventHandler() {
        }

        @SubscribeEvent
        static void registerCommands(RegisterCommandsEvent event) {
            new Commands().register(event.getDispatcher(), event.getBuildContext());
        }
    }
}

