/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui.screen.edit;

import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.gui.TriggerButtonManager;
import dev.terminalmc.clientsort.client.gui.screen.edit.EditorScreen;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.util.Localization;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SelectorScreen
extends Screen {
    private final Screen lastScreen;
    private final AbstractContainerScreen<?> underlay;
    private final LinkedList<TriggerButton> buttons = new LinkedList();

    public SelectorScreen(AbstractContainerScreen<?> underlay) {
        this(underlay, (Screen)underlay);
    }

    public SelectorScreen(AbstractContainerScreen<?> underlay, Screen lastScreen) {
        super((Component)Localization.localized("title", "groupSelector", new Object[0]));
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.underlay = underlay;
        this.lastScreen = lastScreen;
    }

    public void m_7856_() {
        super.m_7856_();
        this.underlay.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        this.reloadButtons();
        this.rebuildGui();
    }

    private void reloadButtons() {
        this.buttons.clear();
        this.buttons.addAll(TriggerButtonManager.getContainerButtons());
        this.buttons.addAll(TriggerButtonManager.getPlayerButtons());
    }

    private void rebuildGui() {
        this.m_169413_();
        Objects.requireNonNull(this.f_96547_);
        StringWidget titleWidget = new StringWidget(0, 2, this.f_96543_, 9, this.f_96539_, this.f_96547_);
        this.m_142416_((GuiEventListener)titleWidget);
        CycleButton toggleButton = CycleButton.m_168896_((Component)Localization.localized("editor", "enabled", new Object[0]).m_130940_(ChatFormatting.GREEN), (Component)Localization.localized("editor", "disabled", new Object[0]).m_130940_(ChatFormatting.RED)).m_168948_((Object)Config.options().showButtons).m_168936_(this.f_96543_ / 2 - 125, this.f_96544_ - 22, 120, 20, (Component)Localization.localized("editor", "buttons", new Object[0]), (buttons, status) -> {
            Config.options().showButtons = status;
            Config.save();
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)toggleButton);
        Button cancelButton = Button.m_253074_((Component)CommonComponents.f_130660_, button -> this.m_7379_()).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 22).m_253046_(120, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.underlay.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (Config.options().showButtons) {
            for (TriggerButton cb : this.buttons) {
                cb.m_87963_(graphics, mouseX, mouseY, partialTick);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7379_() {
        super.m_7379_();
        Screen screen = this.lastScreen;
        if (screen instanceof EditorScreen) {
            EditorScreen pes = (EditorScreen)screen;
            if (!Config.options().showButtons) {
                pes.m_7379_();
                return;
            }
        }
        this.lastScreen.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        for (TriggerButton cb : this.buttons) {
            if (!cb.m_5953_(mouseX, mouseY)) continue;
            cb.m_7435_(Minecraft.m_91087_().m_91106_());
            this.m_7379_();
            cb.openEditScreen();
        }
        return false;
    }
}

