/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.client;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Operation;
import dev.terminalmc.clientsort.client.interaction.InteractionManager;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientOperator;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayDeque;
import java.util.BitSet;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClientSurvivalOperator
extends ClientOperator {
    public ClientSurvivalOperator(AbstractContainerScreen<?> screen, Slot originSlot, Operation op) {
        super(screen, originSlot, op);
    }

    @Override
    protected void collect() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation COLLECT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation COLLECT", new Object[0]);
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = this.originScopeSlots[i];
            ItemStack srcStack = this.originScopeStacks[i];
            if (srcStack.m_41619_() || srcStack.m_41613_() >= srcSlot.m_5866_(srcStack)) continue;
            clickEvents.add(this.createClickEvent(srcSlot, 0, false));
            for (int j = 0; j < i; ++j) {
                Slot dstSlot = this.originScopeSlots[j];
                ItemStack dstStack = this.originScopeStacks[j];
                if (dstStack.m_41619_() || dstStack.m_41613_() >= dstSlot.m_5866_(dstStack) || !ItemStack.m_150942_((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.m_5866_(dstStack) - dstStack.m_41613_();
                delta = Math.min(delta, srcStack.m_41613_());
                srcStack.m_41774_(delta);
                dstStack.m_41769_(delta);
                clickEvents.add(this.createClickEvent(dstSlot, 0, false));
                if (srcStack.m_41613_() <= 0) break;
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.m_41613_() > 0) {
                    InteractionManager.push(this.createClickEvent(srcSlot, 0, false));
                } else {
                    this.originScopeStacks[i] = ItemStack.f_41583_;
                }
            }
            clickEvents.clear();
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation COLLECT", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void sort(int[] sortedIds, boolean playSound) {
        int i;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation SORT", new Object[0]);
        }
        int slotCount = this.originScopeStacks.length;
        int[] srcToDst = new int[slotCount];
        for (int i2 = 0; i2 < slotCount; ++i2) {
            srcToDst[sortedIds[i2]] = i2;
        }
        BitSet done = new BitSet(slotCount);
        BitSet empty = new BitSet(slotCount);
        for (i = 0; i < slotCount; ++i) {
            if (i == sortedIds[i]) {
                done.set(i);
            }
            if (!this.originScopeStacks[i].m_41619_()) continue;
            empty.set(i);
        }
        block2: for (i = 0; i < slotCount; ++i) {
            if (done.get(i)) continue;
            if (empty.get(sortedIds[i])) {
                done.set(sortedIds[i]);
                continue;
            }
            InteractionManager.push(this.createClickEvent(this.originScopeSlots[sortedIds[i]], 0, playSound));
            ItemStack carriedStack = this.originScopeStacks[sortedIds[i]];
            this.originScopeStacks[sortedIds[i]] = ItemStack.f_41583_;
            empty.set(sortedIds[i]);
            Slot workingSlot = this.originScopeSlots[sortedIds[i]];
            int dstId = i;
            do {
                boolean clickOnItemWithBundle;
                if (!empty.get(dstId) && ItemStack.m_150942_((ItemStack)carriedStack, (ItemStack)this.originScopeStacks[dstId])) {
                    if (carriedStack.m_41613_() == this.originScopeStacks[dstId].m_41613_()) {
                        done.set(dstId);
                        dstId = srcToDst[dstId];
                        continue;
                    }
                    if (carriedStack.m_41613_() < this.originScopeStacks[dstId].m_41613_()) {
                        Slot dstSlot = this.originScopeSlots[dstId];
                        InteractionManager.push(this.createClickEvent(workingSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(dstSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(workingSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(dstSlot, 0, playSound));
                        InteractionManager.push(this.createClickEvent(workingSlot, 0, playSound));
                        ItemStack tmp = carriedStack;
                        carriedStack = this.originScopeStacks[dstId];
                        this.originScopeStacks[dstId] = tmp;
                        done.set(dstId);
                        dstId = srcToDst[dstId];
                        continue;
                    }
                }
                int mouseButton = 0;
                boolean clickOnBundleWithItem = ClientSurvivalOperator.isBundle(this.originScopeStacks[dstId]) && !carriedStack.m_41619_();
                boolean bl = clickOnItemWithBundle = ClientSurvivalOperator.isBundle(carriedStack) && !this.originScopeStacks[dstId].m_41619_();
                if (Config.options().bundlesUseLeftClick && (clickOnBundleWithItem || clickOnItemWithBundle)) {
                    mouseButton = 1;
                }
                InteractionManager.push(this.createClickEvent(this.originScopeSlots[dstId], mouseButton, playSound));
                ItemStack tmp = carriedStack;
                carriedStack = this.originScopeStacks[dstId];
                this.originScopeStacks[dstId] = tmp;
                done.set(dstId);
                if (empty.get(dstId)) continue block2;
                dstId = srcToDst[dstId];
            } while (!done.get(dstId));
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation SORT", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void fillStacks() {
        boolean playSound;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: other scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation STACK_FILL", new Object[0]);
        }
        if (playSound = SoundManager.shouldPlayOtherSounds()) {
            SoundManager.resetForCount(SoundManager.estimateStackFillSounds(this.originScopeStacks, this.otherScopeStacks));
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = this.originScopeSlots[i];
            ItemStack srcStack = this.originScopeStacks[i];
            if (srcStack.m_41619_()) continue;
            clickEvents.add(this.createClickEvent(srcSlot, 0, false));
            for (int j = 0; j < this.otherScopeSlots.length; ++j) {
                Slot dstSlot = this.otherScopeSlots[j];
                ItemStack dstStack = this.otherScopeStacks[j];
                if (dstStack.m_41619_() || dstStack.m_41613_() >= dstSlot.m_5866_(dstStack) || !ItemStack.m_150942_((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.m_5866_(dstStack) - dstStack.m_41613_();
                delta = Math.min(delta, srcStack.m_41613_());
                srcStack.m_41764_(srcStack.m_41613_() - delta);
                dstStack.m_41764_(dstStack.m_41613_() + delta);
                clickEvents.add(this.createClickEvent(dstSlot, 0, playSound));
                if (srcStack.m_41613_() <= 0) break;
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.m_41613_() > 0) {
                    InteractionManager.push(this.createClickEvent(srcSlot, 0, false));
                } else {
                    this.originScopeStacks[i] = ItemStack.f_41583_;
                }
            }
            clickEvents.clear();
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation STACK_FILL", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void matchTransfer() {
        this.transfer(ClientSurvivalOperator.collectMatchingSlots(this.originScopeSlots, this.otherScopeStacks, Config.options().alwaysMatchByType, Config.options().typeMatchItemCache));
    }

    @Override
    protected void transfer() {
        this.transfer(this.originScopeSlots);
    }

    protected void transfer(Slot[] originSlots) {
        boolean playSound;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation (MATCH_)TRANSFER: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (originSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation (MATCH_)TRANSFER: origin slots is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation (MATCH_)TRANSFER: other scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation (MATCH_)TRANSFER", new Object[0]);
        }
        ItemStack[] originStacks = this.originScopeStacks;
        if (originSlots != this.originScopeSlots) {
            originStacks = new ItemStack[originSlots.length];
            for (int i = 0; i < originSlots.length; ++i) {
                originStacks[i] = originSlots[i].m_7993_().m_41777_();
            }
        }
        if (playSound = SoundManager.shouldPlayOtherSounds()) {
            SoundManager.resetForCount(SoundManager.estimateTransferSounds(originStacks, this.otherScopeStacks));
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = originSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = originSlots[i];
            ItemStack srcStack = originStacks[i];
            if (srcStack.m_41619_()) continue;
            clickEvents.add(this.createClickEvent(srcSlot, 0, false));
            int emptySlotId = -1;
            for (int j = 0; j < this.otherScopeSlots.length; ++j) {
                Slot dstSlot = this.otherScopeSlots[j];
                ItemStack dstStack = this.otherScopeStacks[j];
                if (dstStack.m_41619_()) {
                    if (emptySlotId != -1) continue;
                    emptySlotId = j;
                    continue;
                }
                if (dstStack.m_41613_() >= dstSlot.m_5866_(dstStack) || !ItemStack.m_150942_((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.m_5866_(dstStack) - dstStack.m_41613_();
                delta = Math.min(delta, srcStack.m_41613_());
                srcStack.m_41764_(srcStack.m_41613_() - delta);
                dstStack.m_41764_(dstStack.m_41613_() + delta);
                clickEvents.add(this.createClickEvent(dstSlot, 0, playSound));
                if (srcStack.m_41619_()) break;
            }
            if (!srcStack.m_41619_() && emptySlotId != -1) {
                Slot dstSlot = this.otherScopeSlots[emptySlotId];
                this.otherScopeStacks[emptySlotId] = srcStack.m_41777_();
                srcStack.m_41764_(0);
                clickEvents.add(this.createClickEvent(dstSlot, 0, playSound));
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.m_41613_() > 0) {
                    InteractionManager.push(this.createClickEvent(srcSlot, 0, false));
                } else {
                    originStacks[i] = ItemStack.f_41583_;
                }
            }
            clickEvents.clear();
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation (MATCH_)TRANSFER", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    private InteractionManager.InteractionEvent createClickEvent(Slot slot, int button, boolean playSound) {
        return new InteractionManager.CallbackEvent(() -> {
            ((AbstractContainerScreenAccessor)this.screen).clientsort$slotClicked(slot, ((ISlot)slot).clientsort$getIndexInMenu(), button, ClickType.PICKUP);
            if (playSound) {
                SoundManager.play();
            }
            return InteractionManager.TICK_WAITER;
        });
    }

    private static boolean isBundle(ItemStack stack) {
        return stack.m_150930_(Items.f_151058_) || stack.m_41720_() instanceof BundleItem;
    }
}

