/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.mixin.client;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.gui.screen.edit.EditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.inventory.helper.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.util.KeybindManager;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen {
    @Shadow
    @Final
    protected AbstractContainerMenu f_97732_;
    @Shadow
    protected Slot f_97734_;
    @Shadow
    private ItemStack f_97711_;

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Shadow
    public abstract T m_6262_();

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeSlotClicked(Slot slot, int slotId, int mouseButton, ClickType type, CallbackInfo ci) {
        if (slotId < 0 && dev.terminalmc.clientsort.client.ClientSort.operatingClient) {
            ci.cancel();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        Supplier<Boolean> op = this.clientsort$getOperation(keyMapping -> keyMapping.m_90830_(button));
        if (op != null && op.get().booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        Supplier<Boolean> op = this.clientsort$getOperation(keyMapping -> keyMapping.m_90832_(keyCode, scanCode));
        if (op != null && op.get().booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    @Nullable
    private Supplier<Boolean> clientsort$getOperation(Function<KeyMapping, Boolean> inputMatcher) {
        boolean isEditKey = inputMatcher.apply(KeybindManager.EDIT_KEY);
        if (!isEditKey && this.f_97734_ == null) {
            return null;
        }
        Options options = this.f_96541_.f_91066_;
        if (inputMatcher.apply(options.f_92097_).booleanValue() && this.f_96541_.f_91072_.m_105290_() && (this.f_97734_.m_6657_() || !this.f_97711_.m_41619_() || !this.f_97732_.m_142621_().m_41619_())) {
            return null;
        }
        if (inputMatcher.apply(options.f_92094_).booleanValue() && this.f_97734_.m_6657_()) {
            return null;
        }
        if (inputMatcher.apply(options.f_92093_).booleanValue()) {
            return null;
        }
        for (int i = 0; i < 9; ++i) {
            if (!inputMatcher.apply(options.f_92056_[i]).booleanValue()) continue;
            return null;
        }
        if (isEditKey) {
            return this::clientsort$openEditor;
        }
        if (inputMatcher.apply(KeybindManager.SORT_KEY).booleanValue()) {
            return this::clientsort$sort;
        }
        if (inputMatcher.apply(KeybindManager.STACK_FILL_KEY).booleanValue()) {
            return this::clientsort$fillStacks;
        }
        if (inputMatcher.apply(KeybindManager.MATCH_TRANSFER_KEY).booleanValue()) {
            return this::clientsort$transferMatching;
        }
        if (inputMatcher.apply(KeybindManager.TRANSFER_KEY).booleanValue()) {
            return this::clientsort$transfer;
        }
        return null;
    }

    @Unique
    private boolean clientsort$openEditor() {
        Minecraft.m_91087_().m_91152_((Screen)new SelectorScreen((AbstractContainerScreen)this));
        return true;
    }

    @Unique
    private boolean clientsort$sort() {
        if (this.f_97734_ == null) {
            return false;
        }
        SortOrder sortOrder = Config.options().sortOrder;
        if (Screen.m_96638_()) {
            sortOrder = Config.options().shiftSortOrder;
        } else if (Screen.m_96637_()) {
            sortOrder = Config.options().ctrlSortOrder;
        } else if (Screen.m_96639_()) {
            sortOrder = Config.options().altSortOrder;
        }
        return SingleUseOperator.sort((AbstractContainerScreen)this, this.f_97734_, false, sortOrder);
    }

    @Unique
    private boolean clientsort$fillStacks() {
        if (this.f_97734_ == null) {
            return false;
        }
        return SingleUseOperator.fillStacks((AbstractContainerScreen)this, this.f_97734_, false);
    }

    @Unique
    private boolean clientsort$transferMatching() {
        if (this.f_97734_ == null) {
            return false;
        }
        return SingleUseOperator.transferMatching((AbstractContainerScreen)this, this.f_97734_, false);
    }

    @Unique
    private boolean clientsort$transfer() {
        if (this.f_97734_ == null) {
            return false;
        }
        return SingleUseOperator.transfer((AbstractContainerScreen)this, this.f_97734_, false);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void afterRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!((Object)((Object)this)).equals(Minecraft.m_91087_().f_91080_)) {
            return;
        }
        if (dev.terminalmc.clientsort.client.ClientSort.overlayMessage != null) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
            dev.terminalmc.clientsort.client.ClientSort.overlayMessage.m_87963_(graphics, mouseX, mouseY, partialTick);
            graphics.m_280168_().m_85849_();
        }
        if (!ClientSort.debug()) {
            return;
        }
        ContainerScreenHelper<AbstractContainerScreen> helper = ContainerScreenHelper.of((AbstractContainerScreen)this);
        float scale = 0.7f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        for (Slot slot : this.f_97732_.f_38839_) {
            int slotId = ((ISlot)slot).clientsort$getIndexInMenu();
            int slotIdx = ((ISlot)slot).clientsort$getIndexInContainer();
            if (!(Minecraft.m_91087_().f_91080_ instanceof EditorScreen)) {
                Object object = ClientSort.getObj(slot, this.m_6262_());
                if (object == null) continue;
                @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
                if (policy != null && policy.ignoredSlots().contains(slotIdx)) {
                    graphics.m_280488_(Minecraft.m_91087_().f_91062_, "\u274c", (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.f_40220_) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.f_40221_) / scale), -65536);
                }
            }
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, String.valueOf(AbstractContainerScreenMixin.m_96638_() ? slotIdx : slotId), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.f_40220_) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.f_40221_ + 12) / scale), -1);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, String.valueOf(helper.getScope(slot).ordinal()), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getLeftPos() + slot.f_40220_ + 12) / scale), (int)((float)(((AbstractContainerScreenAccessor)((Object)this)).clientsort$getTopPos() + slot.f_40221_ + 12) / scale), -1);
        }
        graphics.m_280168_().m_85849_();
    }
}

