/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.order;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.order.StackMatcher;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;

public class CreativeSearchOrder {
    private static final Object2IntMap<StackMatcher> stackPositionMap = new Object2IntOpenHashMap();
    private static final ReadWriteLock stackPositionMapLock;

    public static Lock getReadLock() {
        return stackPositionMapLock.readLock();
    }

    public static int getPosition(ItemStack stack) {
        int pos = stackPositionMap.getInt((Object)StackMatcher.of(stack));
        if (pos == Integer.MAX_VALUE) {
            pos = stackPositionMap.getInt((Object)StackMatcher.ignoreNbt(stack));
        }
        return pos;
    }

    public static void tryRefreshStackPositionMap() {
        if (Config.options().optimizeCreativeSorting) {
            if (ClientSort.emiReloading) {
                ClientSort.updateBlockedByEmi = true;
                ClientSort.LOG.info("Search order update blocked by EMI reload, waiting...", new Object[0]);
            } else {
                CreativeSearchOrder.refreshStackPositionMap();
            }
        } else {
            Lock lock = stackPositionMapLock.writeLock();
            lock.lock();
            stackPositionMap.clear();
            lock.unlock();
        }
    }

    private static void refreshStackPositionMap() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        FeatureFlagSet enabledFeatures = mc.level.enabledFeatures();
        boolean opTab = mc.player.canUseGameMasterBlocks() && (Boolean)mc.options.operatorItemsTab().get() != false;
        CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)enabledFeatures, (!opTab ? 1 : 0) != 0, (HolderLookup.Provider)mc.level.registryAccess());
        ArrayList displayStacks = new ArrayList(CreativeModeTabs.searchTab().getDisplayItems());
        new Thread(() -> {
            Lock lock = stackPositionMapLock.writeLock();
            lock.lock();
            stackPositionMap.clear();
            if (displayStacks.isEmpty()) {
                lock.unlock();
                return;
            }
            int i = 0;
            for (ItemStack stack : displayStacks) {
                StackMatcher plainMatcher = StackMatcher.ignoreNbt(stack);
                if (!stack.hasFoil() || !stackPositionMap.containsKey((Object)plainMatcher)) {
                    stackPositionMap.put((Object)plainMatcher, i);
                    ++i;
                }
                stackPositionMap.put((Object)StackMatcher.of(stack), i);
                ++i;
            }
            lock.unlock();
        }, "ClientSort: creative search stack position lookup builder").start();
    }

    static {
        stackPositionMap.defaultReturnValue(Integer.MAX_VALUE);
        stackPositionMapLock = new ReentrantReadWriteLock();
    }
}

