/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.network.ClientRegistration;
import dev.terminalmc.clientsort.command.Commands;
import dev.terminalmc.clientsort.network.Registration;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="clientsort")
@Mod.EventBusSubscriber(modid="clientsort", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSortForge {
    private static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("clientsort", "main"), () -> "2", v -> NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION).test(v), v -> NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION).test(v));
    public static int packetId = 0;

    public ClientSortForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::dedicatedServerSetup);
        modEventBus.addListener(this::clientSetup);
        ClientSort.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Registration.PAYLOADS_C2S.forEach(ClientSortForge::registerC2S);
    }

    private void dedicatedServerSetup(FMLDedicatedServerSetupEvent event) {
        Registration.PAYLOADS_S2C.forEach(ClientSortForge::registerS2CPayloadOnly);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ClientRegistration.PAYLOADS_S2C.forEach(ClientSortForge::registerS2C);
        dev.terminalmc.clientsort.client.ClientSortForge.init();
    }

    public static <T extends Packet<ServerGamePacketListener>> void registerC2S(Registration.RegisterablePayloadC2S<T> rp) {
        CHANNEL.registerMessage(packetId++, rp.clazz, rp.encoder::accept, rp.decoder::apply, (packet, contextSupplier) -> {
            rp.handler.accept((Packet)packet, ((NetworkEvent.Context)contextSupplier.get()).getSender().m_20194_(), ((NetworkEvent.Context)contextSupplier.get()).getSender());
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static <T extends Packet<ClientGamePacketListener>> void registerS2CPayloadOnly(Registration.RegisterablePayloadS2C<T> rp) {
        CHANNEL.registerMessage(packetId++, rp.clazz, rp.encoder::accept, rp.decoder::apply, (packet, contextSupplier) -> ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <T extends Packet<ClientGamePacketListener>> void registerS2C(ClientRegistration.RegisterablePayloadS2C<T> rp) {
        CHANNEL.registerMessage(packetId++, rp.clazz, rp.encoder::accept, rp.decoder::apply, (packet, contextSupplier) -> {
            rp.handler.accept((Packet)packet, Minecraft.m_91087_(), Minecraft.m_91087_().f_91074_);
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @Mod.EventBusSubscriber(modid="clientsort")
    static class GameEventHandler {
        GameEventHandler() {
        }

        @SubscribeEvent
        static void registerCommands(RegisterCommandsEvent event) {
            new Commands().register(event.getDispatcher(), event.getBuildContext());
        }
    }
}

