/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.util;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class PolicyManager {
    private static final Set<Class<?>> policyClasses = new LinkedHashSet();

    private PolicyManager() {
    }

    public static void reloadPolicyClasses(Set<String> classNames) {
        policyClasses.clear();
        for (String className : classNames) {
            try {
                policyClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                if (!ClientSort.debug()) continue;
                ClientSort.LOG.warn("Unable to load policy class '{}': Class not found.", className);
            }
        }
    }

    @Nullable
    public static ClassPolicy getPolicy(Class<?> cls) {
        ClassPolicy policy = Config.options().classPolicies.get(cls.getName());
        if (policy != null) {
            return policy;
        }
        Set matches = policyClasses.stream().filter(c -> c.isAssignableFrom(cls)).collect(Collectors.toSet());
        for (Class c1 : matches) {
            boolean hasSubclass = false;
            for (Class c2 : matches) {
                if (c1.equals(c2) || !c1.isAssignableFrom(c2)) continue;
                hasSubclass = true;
                break;
            }
            if (hasSubclass) continue;
            return Config.options().classPolicies.get(c1.getName());
        }
        return null;
    }
}

