/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerConfig;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.validate.PayloadResult;
import dev.terminalmc.clientsort.platform.services.PlatformServices;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class PayloadHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPayload(MinecraftServer server, ServerPlayer player, int containerId, ThrowingConsumer<AbstractContainerMenu> contextValidator, ThrowingConsumer<AbstractContainerMenu> schemaValidator, ThrowingConsumer<AbstractContainerMenu> operator, ResourceLocation payloadChannel, ResourceLocation responseChannel, BiFunction<PayloadResult, String, Packet<ClientGamePacketListener>> responseProvider) {
        AbstractContainerMenu menu = null;
        PayloadResult result = PayloadResult.SUCCESS;
        String message = "";
        try {
            menu = PayloadHandler.getMenu(player, containerId);
            menu.m_150443_();
            contextValidator.accept(menu);
            schemaValidator.accept(menu);
            operator.accept(menu);
        }
        catch (Exception e) {
            if (e instanceof PayloadHandlerException) {
                PayloadHandlerException ex = (PayloadHandlerException)e;
                result = ex.result;
                message = ex.getMessage();
            } else {
                result = PayloadResult.FAILURE;
                message = PayloadHandlerException.GENERIC_MESSAGE;
                ClientSort.LOG.error("Encountered an unexpected exception while handling payload '{}' from player '{}': {}", payloadChannel, player, e);
            }
        }
        finally {
            if (menu != null) {
                menu.m_150444_();
                menu.m_38946_();
            }
            if (PlatformServices.getInstance().canSendToPlayer(player, responseChannel)) {
                PlatformServices.getInstance().sendToPlayer(player, responseChannel, responseProvider.apply(result, message));
            }
        }
    }

    public static void validate(MinecraftServer server, ItemStack expected, ItemStack actual, Supplier<String> message, Consumer<String> policySetter) throws PayloadHandlerException.InconsistentStateException {
        boolean invalid = false;
        boolean log = false;
        boolean error = false;
        if (ServerConfig.serverOptions().alwaysLogUnexpectedResults) {
            log = true;
        }
        if (server.m_6982_() && ServerConfig.serverOptions().validationActiveServer) {
            log = true;
            error = true;
        }
        if (!(!log && !ServerConfig.serverOptions().validateItemType || expected.m_41619_() || actual.m_41619_() || ItemStack.m_150942_((ItemStack)expected, (ItemStack)actual))) {
            invalid = true;
        }
        if (log || ServerConfig.serverOptions().validateStackSize) {
            int sizeDifference;
            int n = sizeDifference = expected.m_41613_() > actual.m_41613_() ? expected.m_41613_() - actual.m_41613_() : actual.m_41613_() - expected.m_41613_();
            if (sizeDifference > 0 && sizeDifference >= ServerConfig.serverOptions().validateStackSizeThreshold) {
                invalid = true;
            }
        }
        if (invalid && log) {
            String msg = String.format("%s: Expected '%s' in destination after set, got '%s'!", message.get(), expected, actual);
            if (!error) {
                ClientSort.LOG.warn(msg, new Object[0]);
            } else {
                ClientSort.LOG.error(msg, new Object[0]);
                policySetter.accept(msg);
                throw new PayloadHandlerException.InconsistentStateException(msg);
            }
        }
    }

    @NotNull
    private static AbstractContainerMenu getMenu(ServerPlayer player, int containerId) throws PayloadHandlerException.InvalidDataException {
        InventoryMenu menu;
        if (containerId == player.f_36095_.f_38840_) {
            menu = player.f_36095_;
        } else if (containerId == player.f_36096_.f_38840_) {
            menu = player.f_36096_;
        } else {
            throw new PayloadHandlerException.InvalidDataException(String.format("Container ID '%d' does not match player inventory or container!", containerId));
        }
        if (!menu.m_6875_((Player)player)) {
            throw new PayloadHandlerException.InvalidDataException(String.format("Container ID '%d' is not valid for the player!", containerId));
        }
        return menu;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

